/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeComponentDTO;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.PendingEventDataAccess;
import io.hops.metadata.yarn.entity.PendingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PendingEventClusterJ
implements TablesDef.PendingEventTableDef,
PendingEventDataAccess<PendingEvent> {
    private static final Log LOG = LogFactory.getLog(PendingEventClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void createPendingEvent(PendingEvent persistedEvent) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        PendingEventDTO dto = this.createPersistable(persistedEvent, session);
        session.makePersistent(dto);
        session.release(dto);
    }

    public void removePendingEvent(PendingEvent persistedEvent) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        PendingEventDTO dto = this.createPersistable(persistedEvent, session);
        session.deletePersistent(dto);
        session.release(dto);
    }

    public void addAll(Collection<PendingEvent> toAddPendingEvent) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<PendingEventDTO> toPersist = new ArrayList<PendingEventDTO>();
        for (PendingEvent pendEvent : toAddPendingEvent) {
            PendingEventDTO pendingEventDTO = this.createPersistable(new PendingEvent(pendEvent.getId().getNodeId(), pendEvent.getType(), pendEvent.getStatus(), pendEvent.getId().getEventId().intValue(), pendEvent.getContains()), session);
            toPersist.add(pendingEventDTO);
        }
        session.savePersistentAll(toPersist);
        session.release(toPersist);
    }

    public void add(PendingEvent toAdd) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        PendingEventDTO pendingEventDTO = this.createPersistable(new PendingEvent(toAdd.getId().getNodeId(), toAdd.getType(), toAdd.getStatus(), toAdd.getId().getEventId().intValue(), toAdd.getContains()), session);
        session.savePersistent(pendingEventDTO);
        session.release(pendingEventDTO);
    }

    public void removeAll(Collection<PendingEvent> toRemovePendingEvents) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<PendingEventDTO> toRemove = new ArrayList<PendingEventDTO>();
        for (PendingEvent pendEvent : toRemovePendingEvents) {
            toRemove.add(this.createPersistable(pendEvent, session));
        }
        session.deletePersistentAll(toRemove);
        session.release(toRemove);
    }

    public List<PendingEvent> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ PendingEvent.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingEventDTO> dobj = qb.createQueryDefinition(PendingEventDTO.class);
        HopsQuery<PendingEventDTO> query = session.createQuery(dobj);
        List<PendingEventDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ PendingEvent.getAll - FINISH");
        List<PendingEvent> result = this.createPendingEventList(queryResults);
        session.release(queryResults);
        return result;
    }

    public List<PendingEvent> getAll(int status) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingEventDTO> dobj = qb.createQueryDefinition(PendingEventDTO.class);
        HopsPredicate pred1 = dobj.get("status").equal(dobj.param("status"));
        dobj.where(pred1);
        HopsQuery<PendingEventDTO> query = session.createQuery(dobj);
        query.setParameter("status", status);
        List<PendingEventDTO> queryResults = query.getResultList();
        List<PendingEvent> result = this.createPendingEventList(queryResults);
        session.release(queryResults);
        return result;
    }

    public PendingEvent findEntry(int pendingEventId, String nodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[3];
        pk[0] = pendingEventId;
        pk[1] = nodeId;
        PendingEventDTO pendingEventDTO = session.find(PendingEventDTO.class, pk);
        PendingEvent result = null;
        if (pendingEventDTO != null) {
            result = new PendingEvent(pendingEventDTO.getrmnodeid(), PendingEvent.Type.valueOf((String)pendingEventDTO.getType()), PendingEvent.Status.valueOf((String)pendingEventDTO.getStatus()), pendingEventDTO.getId(), pendingEventDTO.getContains());
        }
        session.release(pendingEventDTO);
        return result;
    }

    private PendingEventDTO createPersistable(PendingEvent hopPersistedEvent, HopsSession session) throws StorageException {
        PendingEventDTO DTO = session.newInstance(PendingEventDTO.class);
        DTO.setrmnodeid(hopPersistedEvent.getId().getNodeId());
        DTO.setType(hopPersistedEvent.getType().name());
        DTO.setStatus(hopPersistedEvent.getStatus().name());
        DTO.setId(hopPersistedEvent.getId().getEventId());
        DTO.setContains(hopPersistedEvent.getContains());
        return DTO;
    }

    private List<PendingEvent> createPendingEventList(List<PendingEventDTO> results) {
        ArrayList<PendingEvent> hopList = null;
        if (results != null && !results.isEmpty()) {
            hopList = new ArrayList<PendingEvent>(results.size());
            for (PendingEventDTO DTO : results) {
                PendingEvent hop = new PendingEvent(DTO.getrmnodeid(), PendingEvent.Type.valueOf((String)DTO.getType()), PendingEvent.Status.valueOf((String)DTO.getStatus()), DTO.getId(), DTO.getContains());
                hopList.add(hop);
            }
        }
        return hopList;
    }

    @PersistenceCapable(table="yarn_pendingevents")
    public static interface PendingEventDTO
    extends RMNodeComponentDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @PrimaryKey
        @Column(name="rmnodeid")
        public String getrmnodeid();

        public void setrmnodeid(String var1);

        @Column(name="type")
        public String getType();

        public void setType(String var1);

        @Column(name="status")
        public String getStatus();

        public void setStatus(String var1);

        @Column(name="contains")
        public int getContains();

        public void setContains(int var1);
    }
}

