/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExcessReplicaClusterj
implements TablesDef.ExcessReplicaTableDef,
ExcessReplicaDataAccess<ExcessReplica> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_excess_replicas");
    }

    public int countAllUniqueBlk() throws StorageException {
        return MySQLQueryHelper.countAllUnique("hdfs_excess_replicas", "block_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<ExcessReplica> removed, Collection<ExcessReplica> newed, Collection<ExcessReplica> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ExcessReplicaDTO> changes = new ArrayList<ExcessReplicaDTO>();
        ArrayList<ExcessReplicaDTO> deletions = new ArrayList<ExcessReplicaDTO>();
        try {
            ExcessReplicaDTO newInstance;
            for (ExcessReplica exReplica : newed) {
                newInstance = session.newInstance(ExcessReplicaDTO.class);
                this.createPersistable(exReplica, newInstance);
                changes.add(newInstance);
            }
            for (ExcessReplica exReplica : removed) {
                newInstance = session.newInstance(ExcessReplicaDTO.class);
                this.createPersistable(exReplica, newInstance);
                deletions.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public List<ExcessReplica> findExcessReplicaBySid(int sid) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ExcessReplicaDTO> qdt = qb.createQueryDefinition(ExcessReplicaDTO.class);
        qdt.where(qdt.get("storageId").equal(qdt.param("sid")));
        HopsQuery<ExcessReplicaDTO> query = session.createQuery(qdt);
        query.setParameter("sid", sid);
        List<ExcessReplicaDTO> dtos = query.getResultList();
        List<ExcessReplica> ler = this.createList(dtos);
        session.release(dtos);
        return ler;
    }

    public List<ExcessReplica> findExcessReplicaByBlockId(long bId, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ExcessReplicaDTO> qdt = qb.createQueryDefinition(ExcessReplicaDTO.class);
        HopsPredicate pred1 = qdt.get("blockId").equal(qdt.param("blockIdParam"));
        HopsPredicate pred2 = qdt.get("iNodeId").equal(qdt.param("iNodeIdParam"));
        qdt.where(pred1.and(pred2));
        HopsQuery<ExcessReplicaDTO> query = session.createQuery(qdt);
        query.setParameter("blockIdParam", bId);
        query.setParameter("iNodeIdParam", inodeId);
        List<ExcessReplicaDTO> dtos = query.getResultList();
        List<ExcessReplica> ler = this.createList(dtos);
        session.release(dtos);
        return ler;
    }

    public List<ExcessReplica> findExcessReplicaByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ExcessReplicaDTO> qdt = qb.createQueryDefinition(ExcessReplicaDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").equal(qdt.param("iNodeIdParam"));
        qdt.where(pred1);
        HopsQuery<ExcessReplicaDTO> query = session.createQuery(qdt);
        query.setParameter("iNodeIdParam", inodeId);
        List<ExcessReplicaDTO> dtos = query.getResultList();
        List<ExcessReplica> ler = this.createList(dtos);
        session.release(dtos);
        return ler;
    }

    public List<ExcessReplica> findExcessReplicaByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ExcessReplicaDTO> qdt = qb.createQueryDefinition(ExcessReplicaDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").in(qdt.param("iNodeIdParam"));
        qdt.where(pred1);
        HopsQuery<ExcessReplicaDTO> query = session.createQuery(qdt);
        query.setParameter("iNodeIdParam", Longs.asList((long[])inodeIds));
        List<ExcessReplicaDTO> dtos = query.getResultList();
        List<ExcessReplica> ler = this.createList(dtos);
        session.release(dtos);
        return ler;
    }

    public ExcessReplica findByPK(long bId, int sid, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[4];
        pk[0] = inodeId;
        pk[1] = bId;
        pk[2] = sid;
        ExcessReplicaDTO invTable = session.find(ExcessReplicaDTO.class, pk);
        if (invTable == null) {
            return null;
        }
        ExcessReplica result = this.createReplica(invTable);
        session.release(invTable);
        return result;
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        try {
            while (this.countAll() != 0) {
                MysqlServerConnector.truncateTable("hdfs_excess_replicas", 1000);
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
    }

    private List<ExcessReplica> createList(List<ExcessReplicaDTO> list) {
        ArrayList<ExcessReplica> result = new ArrayList<ExcessReplica>();
        for (ExcessReplicaDTO item : list) {
            result.add(this.createReplica(item));
        }
        return result;
    }

    private ExcessReplica createReplica(ExcessReplicaDTO exReplicaTable) {
        return new ExcessReplica(exReplicaTable.getStorageId(), exReplicaTable.getBlockId(), exReplicaTable.getINodeId());
    }

    private void createPersistable(ExcessReplica exReplica, ExcessReplicaDTO exReplicaTable) {
        exReplicaTable.setBlockId(exReplica.getBlockId());
        exReplicaTable.setStorageId(exReplica.getStorageId());
        exReplicaTable.setINodeId(exReplica.getInodeId());
    }

    @PersistenceCapable(table="hdfs_excess_replicas")
    @PartitionKey(column="inode_id")
    @Index(name="storage_idx")
    public static interface ExcessReplicaDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);
    }
}

