/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.mysqlserver;

import io.hops.exception.StorageException;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MySQLQueryHelper {
    public static final String COUNT_QUERY = "select count(*) from %s";
    public static final String COUNT_QUERY_UNIQUE = "select count(distinct %s) from %s";
    public static final String SELECT_EXISTS = "select exists(%s)";
    public static final String SELECT_EXISTS_QUERY = "select * from %s";
    public static final String MIN = "select min(%s) from %s";
    public static final String MAX = "select max(%s) from %s";
    private static MysqlServerConnector connector = MysqlServerConnector.getInstance();

    public static int countAll(String tableName) throws StorageException {
        String query = String.format(COUNT_QUERY, tableName);
        return MySQLQueryHelper.executeIntAggrQuery(query);
    }

    public static int countAllUnique(String tableName, String columnName) throws StorageException {
        String query = String.format(COUNT_QUERY_UNIQUE, columnName, tableName);
        return MySQLQueryHelper.executeIntAggrQuery(query);
    }

    public static int countWithCriterion(String tableName, String criterion) throws StorageException {
        StringBuilder queryBuilder = new StringBuilder(String.format(COUNT_QUERY, tableName)).append(" where ").append(criterion);
        return MySQLQueryHelper.executeIntAggrQuery(queryBuilder.toString());
    }

    public static int countUniqueWithCriterion(String tableName, String columnNames, String criterion) throws StorageException {
        StringBuilder queryBuilder = new StringBuilder(String.format(COUNT_QUERY_UNIQUE, columnNames, tableName)).append(" where ").append(criterion);
        return MySQLQueryHelper.executeIntAggrQuery(queryBuilder.toString());
    }

    public static boolean exists(String tableName, String criterion) throws StorageException {
        StringBuilder query = new StringBuilder(String.format(SELECT_EXISTS_QUERY, tableName));
        query.append(" where ").append(criterion);
        return MySQLQueryHelper.executeBooleanQuery(String.format(SELECT_EXISTS, query.toString()));
    }

    public static long minLong(String tableName, String column, String criterion) throws StorageException {
        StringBuilder query = new StringBuilder(String.format(MIN, column, tableName));
        query.append(" where ").append(criterion);
        return MySQLQueryHelper.executeLongAggrQuery(query.toString());
    }

    public static long maxLong(String tableName, String column, String criterion) throws StorageException {
        StringBuilder query = new StringBuilder(String.format(MAX, column, tableName));
        query.append(" where ").append(criterion);
        return MySQLQueryHelper.executeLongAggrQuery(query.toString());
    }

    public static long maxLong(String tableName, String column) throws StorageException {
        StringBuilder query = new StringBuilder(String.format(MAX, column, tableName));
        return MySQLQueryHelper.executeLongAggrQuery(query.toString());
    }

    private static int executeIntAggrQuery(final String query) throws StorageException {
        return MySQLQueryHelper.execute(query, new ResultSetHandler<Integer>(){

            @Override
            public Integer handle(ResultSet result) throws SQLException, StorageException {
                if (!result.next()) {
                    throw new StorageException(String.format("result set is empty. Query: %s", query));
                }
                return result.getInt(1);
            }
        });
    }

    public static long executeLongAggrQuery(final String query) throws StorageException {
        return MySQLQueryHelper.execute(query, new ResultSetHandler<Long>(){

            @Override
            public Long handle(ResultSet result) throws SQLException, StorageException {
                if (!result.next()) {
                    throw new StorageException(String.format("result set is empty. Query: %s", query));
                }
                return result.getLong(1);
            }
        });
    }

    private static boolean executeBooleanQuery(final String query) throws StorageException {
        return MySQLQueryHelper.execute(query, new ResultSetHandler<Boolean>(){

            @Override
            public Boolean handle(ResultSet result) throws SQLException, StorageException {
                if (!result.next()) {
                    throw new StorageException(String.format("result set is empty. Query: %s", query));
                }
                return result.getBoolean(1);
            }
        });
    }

    public static int execute(String query) throws StorageException {
        try {
            Connection conn = connector.obtainSession();
            PreparedStatement s = conn.prepareStatement(query);
            int n = s.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            connector.closeSession();
        }
    }

    public static <R> R execute(String query, ResultSetHandler<R> handler) throws StorageException {
        try {
            Connection conn = connector.obtainSession();
            PreparedStatement s = conn.prepareStatement(query);
            ResultSet result = s.executeQuery();
            R r = handler.handle(result);
            return r;
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            connector.closeSession();
        }
    }

    public static interface ResultSetHandler<R> {
        public R handle(ResultSet var1) throws SQLException, StorageException;
    }
}

