/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.LockMode;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.DBSession;
import io.hops.metadata.ndb.wrapper.HopsExceptionHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.ndb.wrapper.HopsSessionFactory;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBSessionProvider
implements Runnable {
    static final Log LOG = LogFactory.getLog(DBSessionProvider.class);
    static HopsSessionFactory sessionFactory;
    private ConcurrentLinkedQueue<DBSession> sessionPool = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DBSession> toGC = new ConcurrentLinkedQueue();
    private final int MAX_REUSE_COUNT;
    private Properties conf;
    private final Random rand;
    private AtomicInteger sessionsCreated = new AtomicInteger(0);
    private long[] rollingAvg;
    private AtomicInteger rollingAvgIndex = new AtomicInteger(-1);
    private boolean automaticRefresh = false;
    private Thread thread;

    public DBSessionProvider(Properties conf, int reuseCount, int initialPoolSize) throws StorageException {
        this.conf = conf;
        if (reuseCount <= 0) {
            System.err.println("Invalid value for session reuse count");
            System.exit(-1);
        }
        this.MAX_REUSE_COUNT = reuseCount;
        this.rand = new Random(System.currentTimeMillis());
        this.rollingAvg = new long[initialPoolSize];
        this.start(initialPoolSize);
    }

    private void start(int initialPoolSize) throws StorageException {
        System.out.println("Database connect string: " + this.conf.get("com.mysql.clusterj.connectstring"));
        System.out.println("Database name: " + this.conf.get("com.mysql.clusterj.database"));
        System.out.println("Max Transactions: " + this.conf.get("com.mysql.clusterj.max.transactions"));
        try {
            sessionFactory = new HopsSessionFactory(ClusterJHelper.getSessionFactory((Map)this.conf));
        }
        catch (ClusterJException ex) {
            throw HopsExceptionHelper.wrap(ex);
        }
        for (int i = 0; i < initialPoolSize; ++i) {
            this.sessionPool.add(this.initSession());
        }
        this.thread = new Thread((Runnable)this, "Session Pool Refresh Daemon");
        this.thread.setDaemon(true);
        this.automaticRefresh = true;
        this.thread.start();
    }

    private DBSession initSession() throws StorageException {
        Long startTime = System.currentTimeMillis();
        HopsSession session = sessionFactory.getSession();
        Long sessionCreationTime = System.currentTimeMillis() - startTime;
        this.rollingAvg[this.rollingAvgIndex.incrementAndGet() % this.rollingAvg.length] = sessionCreationTime;
        int reuseCount = this.rand.nextInt(this.MAX_REUSE_COUNT) + 1;
        DBSession dbSession = new DBSession(session, reuseCount);
        this.sessionsCreated.incrementAndGet();
        return dbSession;
    }

    private void closeSession(DBSession dbSession) throws StorageException {
        Long startTime = System.currentTimeMillis();
        dbSession.getSession().close();
        Long sessionCreationTime = System.currentTimeMillis() - startTime;
        this.rollingAvg[this.rollingAvgIndex.incrementAndGet() % this.rollingAvg.length] = sessionCreationTime;
    }

    public void stop() throws StorageException {
        this.automaticRefresh = false;
        while (!this.sessionPool.isEmpty()) {
            DBSession dbsession = (DBSession)this.sessionPool.remove();
            this.closeSession(dbsession);
        }
    }

    public DBSession getSession() throws StorageException {
        try {
            DBSession session = (DBSession)this.sessionPool.remove();
            return session;
        }
        catch (NoSuchElementException e) {
            LOG.warn((Object)"DB Sessino provider cant keep up with the demand for new sessions");
            return this.initSession();
        }
    }

    public void returnSession(DBSession returnedSession, boolean forceClose) throws StorageException {
        returnedSession.setSessionUseCount(returnedSession.getSessionUseCount() + 1);
        if (returnedSession.getSessionUseCount() >= returnedSession.getMaxReuseCount() || forceClose) {
            this.toGC.add(returnedSession);
        } else {
            returnedSession.getSession().setLockMode(LockMode.READ_COMMITTED);
            this.sessionPool.add(returnedSession);
        }
    }

    public double getSessionCreationRollingAvg() {
        double avg = 0.0;
        for (long aRollingAvg : this.rollingAvg) {
            avg += (double)aRollingAvg;
        }
        return avg /= (double)this.rollingAvg.length;
    }

    public int getTotalSessionsCreated() {
        return this.sessionsCreated.get();
    }

    public int getAvailableSessions() {
        return this.sessionPool.size();
    }

    @Override
    public void run() {
        while (this.automaticRefresh) {
            int i;
            try {
                int toGCSize = this.toGC.size();
                if (toGCSize > 0) {
                    LOG.debug((Object)("Renewing a session(s) " + toGCSize));
                    for (i = 0; i < toGCSize; ++i) {
                        DBSession session = (DBSession)this.toGC.remove();
                        session.getSession().close();
                    }
                    for (i = 0; i < toGCSize; ++i) {
                        this.sessionPool.add(this.initSession());
                    }
                }
                Thread.sleep(5L);
            }
            catch (NoSuchElementException e) {
                for (i = 0; i < 100; ++i) {
                    try {
                        this.sessionPool.add(this.initSession());
                        continue;
                    }
                    catch (StorageException e1) {
                        LOG.error((Object)e1);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex);
                Thread.currentThread().interrupt();
            }
            catch (StorageException e) {
                LOG.error((Object)e);
            }
        }
    }
}

