/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.dalimpl.yarn.ContainerIdToCleanClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.ContainerStatusClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.NextHeartbeatClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.PendingEventClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeApplicationsClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.RMNodeComponentDTO;
import io.hops.metadata.ndb.dalimpl.yarn.ResourceClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.UpdatedContainerInfoClusterJ;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.dal.FullRMNodeDataAccess;
import io.hops.metadata.yarn.entity.ContainerId;
import io.hops.metadata.yarn.entity.NextHeartbeat;
import io.hops.metadata.yarn.entity.PendingEvent;
import io.hops.metadata.yarn.entity.RMNode;
import io.hops.metadata.yarn.entity.RMNodeApplication;
import io.hops.metadata.yarn.entity.RMNodeComps;
import io.hops.metadata.yarn.entity.Resource;
import io.hops.metadata.yarn.entity.UpdatedContainerInfo;
import java.util.ArrayList;
import java.util.List;

public class FullRMNodeClusterJ
implements FullRMNodeDataAccess<RMNodeComps> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();
    private final ResourceClusterJ resourceDA = new ResourceClusterJ();
    private final PendingEventClusterJ pendingEventDA = new PendingEventClusterJ();
    private final ContainerIdToCleanClusterJ containerToCleanDA = new ContainerIdToCleanClusterJ();
    private final RMNodeApplicationsClusterJ finishedApplicationsDA = new RMNodeApplicationsClusterJ();
    private final UpdatedContainerInfoClusterJ updatedContainerDA = new UpdatedContainerInfoClusterJ();

    public RMNodeComps findByNodeId(String nodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<UpdatedContainerInfo> hopUpdatedContainerInfo = this.updatedContainerDA.findByRMNodeList(nodeId);
        Resource hopResource = this.resourceDA.findEntry(nodeId);
        List<ContainerId> hopContainerIdsToClean = this.containerToCleanDA.findByRMNode(nodeId);
        List<RMNodeApplication> hopFinishedApplications = this.finishedApplicationsDA.findByRMNode(nodeId);
        ArrayList<RMNodeComponentDTO> components = new ArrayList<RMNodeComponentDTO>();
        RMNodeClusterJ.RMNodeDTO rmnodeDTO = session.newInstance(RMNodeClusterJ.RMNodeDTO.class, nodeId);
        rmnodeDTO = session.load(rmnodeDTO);
        components.add(rmnodeDTO);
        NextHeartbeatClusterJ.NextHeartbeatDTO nextHBDTO = session.newInstance(NextHeartbeatClusterJ.NextHeartbeatDTO.class, nodeId);
        nextHBDTO = session.load(nextHBDTO);
        components.add(nextHBDTO);
        ArrayList<ContainerStatusClusterJ.ContainerStatusDTO> containerStatusDTOs = new ArrayList<ContainerStatusClusterJ.ContainerStatusDTO>();
        if (hopUpdatedContainerInfo != null) {
            for (UpdatedContainerInfo hop : hopUpdatedContainerInfo) {
                Object[] pk = new Object[]{hop.getContainerId(), hop.getRmnodeid(), hop.getUpdatedContainerInfoId()};
                ContainerStatusClusterJ.ContainerStatusDTO containerStatusDTO = session.newInstance(ContainerStatusClusterJ.ContainerStatusDTO.class, pk);
                containerStatusDTO = session.load(containerStatusDTO);
                containerStatusDTOs.add(containerStatusDTO);
            }
        }
        session.flush();
        RMNode hopRMNode = null;
        NextHeartbeat hopNextHeartbeat = null;
        for (RMNodeComponentDTO comp : components) {
            if (comp instanceof RMNodeClusterJ.RMNodeDTO) {
                hopRMNode = RMNodeClusterJ.createHopRMNode((RMNodeClusterJ.RMNodeDTO)comp);
                if (hopRMNode.getHostName() != null) continue;
                session.release(components);
                session.release(containerStatusDTOs);
                session.release(nextHBDTO);
                session.release(rmnodeDTO);
                return null;
            }
            if (!(comp instanceof NextHeartbeatClusterJ.NextHeartbeatDTO)) continue;
            hopNextHeartbeat = NextHeartbeatClusterJ.createHopNextHeartbeat((NextHeartbeatClusterJ.NextHeartbeatDTO)comp);
        }
        if (hopRMNode == null) {
            return null;
        }
        PendingEvent hopPendingEvent = this.pendingEventDA.findEntry(hopRMNode.getPendingEventId(), nodeId);
        String rmNodeId = null;
        if (hopPendingEvent != null) {
            rmNodeId = hopPendingEvent.getId().getNodeId();
        } else if (hopRMNode != null) {
            rmNodeId = hopRMNode.getNodeId();
        }
        RMNodeComps result = new RMNodeComps(hopRMNode, hopResource, hopPendingEvent, hopUpdatedContainerInfo, ContainerStatusClusterJ.createList(containerStatusDTOs));
        session.release(components);
        session.release(containerStatusDTOs);
        session.release(nextHBDTO);
        session.release(rmnodeDTO);
        return result;
    }
}

