/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.RMLoadDataAccess;
import io.hops.metadata.yarn.entity.Load;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RMLoadClusterJ
implements TablesDef.RMLoadTableDef,
RMLoadDataAccess<Load> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void update(Load entry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        RMLoadDTO dto = this.createPersistable(entry, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    public Map<String, Load> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<RMLoadDTO> dobj = qb.createQueryDefinition(RMLoadDTO.class);
        HopsQuery<RMLoadDTO> query = session.createQuery(dobj);
        List<RMLoadDTO> queryResults = query.getResultList();
        Map<String, Load> result = this.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    private RMLoadDTO createPersistable(Load entry, HopsSession session) throws StorageException {
        RMLoadDTO persistable = session.newInstance(RMLoadDTO.class);
        persistable.setrmhostname(entry.getRmHostName());
        persistable.setload(entry.getLoad());
        return persistable;
    }

    private Map<String, Load> createMap(List<RMLoadDTO> results) {
        HashMap<String, Load> map = new HashMap<String, Load>();
        for (RMLoadDTO dto : results) {
            if (dto == null) continue;
            Load hop = this.createHopLoad(dto);
            map.put(hop.getRmHostName(), hop);
        }
        return map;
    }

    private Load createHopLoad(RMLoadDTO loadDTO) {
        return new Load(loadDTO.getrmhostname(), loadDTO.getload());
    }

    @PersistenceCapable(table="yarn_rms_load")
    public static interface RMLoadDTO {
        @PrimaryKey
        @Column(name="rmhostname")
        public String getrmhostname();

        public void setrmhostname(String var1);

        @Column(name="load")
        public long getload();

        public void setload(long var1);
    }
}

