/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CacheDirectivePathClusterj
implements TablesDef.CacheDirectivePathTableDef {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private int chunkSize = 250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String find(long id) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CacheDirectivePathDTO> dobj = qb.createQueryDefinition(CacheDirectivePathDTO.class);
        HopsPredicate pred1 = dobj.get("id").equal(dobj.param("id"));
        dobj.where(pred1);
        HopsQuery<CacheDirectivePathDTO> query = session.createQuery(dobj);
        query.setParameter("id", id);
        List<CacheDirectivePathDTO> results = null;
        try {
            results = query.getResultList();
            if (results == null) {
                String string = null;
                return string;
            }
            String string = this.convert(results);
            return string;
        }
        finally {
            session.release(results);
        }
    }

    public void add(Map<Long, String> modified) throws StorageException {
        ArrayList<CacheDirectivePathDTO> changes = new ArrayList<CacheDirectivePathDTO>();
        HopsSession session = this.connector.obtainSession();
        for (long id : modified.keySet()) {
            changes.addAll(this.createPersistable(id, modified.get(id), session));
        }
        session.savePersistentAll(changes);
        session.release(changes);
    }

    private String convert(List<CacheDirectivePathDTO> pathParts) {
        CharSequence[] pathArray = new String[pathParts.size()];
        for (CacheDirectivePathDTO part : pathParts) {
            pathArray[part.getIndex()] = part.getValue();
        }
        return String.join((CharSequence)"", pathArray);
    }

    private Collection<CacheDirectivePathDTO> createPersistable(long id, String path, HopsSession session) throws StorageException {
        short s = (int)Math.ceil((float)path.length() / (float)this.chunkSize);
        ArrayList<CacheDirectivePathDTO> pathParts = new ArrayList<CacheDirectivePathDTO>(s);
        for (short i = 0; i < s; i = (short)(i + 1)) {
            CacheDirectivePathDTO newInstance = session.newInstance(CacheDirectivePathDTO.class);
            newInstance.setId(id);
            newInstance.setIndex(i);
            newInstance.setValue(path.substring(i * this.chunkSize, Math.min((i + 1) * this.chunkSize, path.length())));
            pathParts.add(newInstance);
        }
        return pathParts;
    }

    @PersistenceCapable(table="hdfs_cache_directive_path")
    public static interface CacheDirectivePathDTO {
        @PrimaryKey
        @Column(name="id")
        public long getId();

        public void setId(long var1);

        @PrimaryKey
        @Column(name="index")
        public short getIndex();

        public void setIndex(short var1);

        @Column(name="value")
        public String getValue();

        public void setValue(String var1);
    }
}

