/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.entity.Replica;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReplicaClusterj
implements TablesDef.ReplicaTableDef,
ReplicaDataAccess<Replica> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<Replica> findReplicasById(long blockId, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockIdParam"));
        HopsPredicate pred2 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("blockIdParam", blockId);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<Replica> findReplicasByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<Replica> findReplicasByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").in(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", Longs.asList((long[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    public Map<Long, Long> findBlockAndInodeIdsByStorageId(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<ReplicaDTO> res = ReplicaClusterj.getReplicas(session, storageId);
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (ReplicaDTO dto : res) {
            map.put(dto.getBlockId(), dto.getINodeId());
        }
        session.release(res);
        return map;
    }

    public Map<Long, Long> findBlockAndInodeIdsByStorageIdAndBucketId(int storageId, int bucketId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("storageId").equal(dobj.param("storageIdParam"));
        HopsPredicate pred2 = dobj.get("hashBucket").equal(dobj.param("bucketIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("storageIdParam", storageId);
        query.setParameter("bucketIdParam", bucketId);
        List<Replica> replicas = this.convertAndRelease(session, query.getResultList());
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        for (Replica replica : replicas) {
            result.put(replica.getBlockId(), replica.getInodeId());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<Replica> removed, Collection<Replica> newed, Collection<Replica> modified) throws StorageException {
        ArrayList<ReplicaDTO> changes = new ArrayList<ReplicaDTO>();
        ArrayList<ReplicaDTO> deletions = new ArrayList<ReplicaDTO>();
        HopsSession session = this.connector.obtainSession();
        try {
            ReplicaDTO newInstance;
            for (Replica replica : removed) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                deletions.add(newInstance);
            }
            for (Replica replica : newed) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            for (Replica replica : modified) {
                newInstance = session.newInstance(ReplicaDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public Map<Long, Long> findBlockAndInodeIdsByStorageIdAndBucketIds(int sId, List<Integer> mismatchedBuckets) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ConcurrentHashMap<Long, Long> results = new ConcurrentHashMap<Long, Long>();
        if (mismatchedBuckets.size() > 0) {
            HopsQueryBuilder qb = session.getQueryBuilder();
            HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
            for (int i = 0; i < mismatchedBuckets.size(); ++i) {
                HopsPredicate pred1 = dobj.get("storageId").equal(dobj.param("storageIdParam"));
                HopsPredicate pred2 = dobj.get("bucketId").equal(dobj.param("bucketIdParam"));
                dobj.where(pred1.and(pred2));
                HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
                query.setParameter("storageIdParam", sId);
                query.setParameter("bucketIdParam", mismatchedBuckets.get(i));
                List<Replica> replicas = this.convertAndRelease(session, query.getResultList());
                for (Replica replica : replicas) {
                    results.put(replica.getBlockId(), replica.getInodeId());
                }
            }
            return results;
        }
        return results;
    }

    public int countAllReplicasForStorageId(int sid) throws StorageException {
        return MySQLQueryHelper.countWithCriterion("hdfs_replicas", String.format("%s=%d", "storage_id", sid));
    }

    protected static Set<Long> getReplicas(int storageId) throws StorageException {
        return MySQLQueryHelper.execute(String.format("SELECT %s FROM %s WHERE %s='%d'", "block_id", "hdfs_replicas", "storage_id", storageId), new MySQLQueryHelper.ResultSetHandler<Set<Long>>(){

            @Override
            public Set<Long> handle(ResultSet result) throws SQLException {
                HashSet blocks = Sets.newHashSet();
                while (result.next()) {
                    blocks.add(result.getLong("block_id"));
                }
                return blocks;
            }
        });
    }

    protected static List<ReplicaDTO> getReplicas(HopsSession session, int storageId) throws StorageException {
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        dobj.where(dobj.get("storageId").equal(dobj.param("param")));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("param", storageId);
        return query.getResultList();
    }

    protected static List<ReplicaDTO> getReplicas(HopsSession session, int storageId, long from, int size) throws StorageException {
        while (ReplicaClusterj.countBlocksInWindow(storageId, from, size) == 0L) {
            from += (long)size;
        }
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        dobj.where(dobj.get("storageId").equal(dobj.param("storageId")));
        dobj.where(dobj.get("blockId").between(dobj.param("minBlockId"), dobj.param("maxBlockId")));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("storageId", storageId);
        query.setParameter("minBlockId", from);
        query.setParameter("maxBlockId", from + (long)size);
        return query.getResultList();
    }

    public boolean hasBlocksWithIdGreaterThan(int storageId, long from) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaDTO> dobj = qb.createQueryDefinition(ReplicaDTO.class);
        dobj.where(dobj.get("storageId").equal(dobj.param("storageId")));
        dobj.where(dobj.get("blockId").greaterEqual(dobj.param("minBlockId")));
        HopsQuery<ReplicaDTO> query = session.createQuery(dobj);
        query.setParameter("storageId", storageId);
        query.setParameter("minBlockId", from);
        query.setLimits(0L, 1L);
        List<ReplicaDTO> dtos = query.getResultList();
        boolean result = !dtos.isEmpty();
        session.release(dtos);
        return result;
    }

    public long findBlockIdAtIndex(int storageId, long index, int maxFetchingSize) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        long startId = 0L;
        long nbBlocks = 0L;
        long prevStartId = 0L;
        long prevNbBlocks = 0L;
        for (int windowSize = maxFetchingSize * 1000; windowSize > maxFetchingSize; windowSize /= 10) {
            while (nbBlocks < index) {
                prevStartId = startId;
                prevNbBlocks = nbBlocks;
                nbBlocks += ReplicaClusterj.countBlocksInWindow(storageId, startId, windowSize).longValue();
                startId += (long)windowSize;
            }
            nbBlocks = prevNbBlocks;
            startId = prevStartId;
        }
        while (nbBlocks < index) {
            List<ReplicaDTO> list = ReplicaClusterj.getReplicas(session, storageId, prevStartId, maxFetchingSize);
            for (ReplicaDTO dto : list) {
                if (++nbBlocks != index) continue;
                return dto.getBlockId();
            }
            startId += (long)maxFetchingSize;
        }
        return 0L;
    }

    private static Long countBlocksInWindow(int storageId, long from, int size) throws StorageException {
        Long result = MySQLQueryHelper.executeLongAggrQuery(String.format("SELECT count(*) FROM %s WHERE %s='%d' and %s>='%d' and %s<=%d", "hdfs_replicas", "storage_id", storageId, "block_id", from, "block_id", from + (long)size));
        return result;
    }

    private List<Replica> convertAndRelease(HopsSession session, List<ReplicaDTO> triplets) throws StorageException {
        ArrayList<Replica> replicas = new ArrayList<Replica>(triplets.size());
        for (ReplicaDTO t : triplets) {
            replicas.add(new Replica(t.getStorageId(), t.getBlockId(), t.getINodeId(), t.getBucketId()));
            session.release(t);
        }
        return replicas;
    }

    private void createPersistable(Replica replica, ReplicaDTO newInstance) {
        newInstance.setBlockId(replica.getBlockId());
        newInstance.setStorageId(replica.getStorageId());
        newInstance.setINodeId(replica.getInodeId());
        newInstance.setBucketId(replica.getBucketId());
    }

    @PersistenceCapable(table="hdfs_replicas")
    @PartitionKey(column="inode_id")
    @Index(name="storage_idx")
    public static interface ReplicaDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="bucket_id")
        public int getBucketId();

        public void setBucketId(int var1);
    }
}

