/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.LeaseCreationLocksDataAccess;
import io.hops.metadata.hdfs.entity.LeaseCreationLock;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeaseCreationLocksClusterj
implements TablesDef.LeaseCreationLocksTableDef,
LeaseCreationLocksDataAccess<Object> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    public static final Log LOG = LogFactory.getLog(LeaseCreationLocksClusterj.class);
    private final int NON_EXISTANT_ROW = -1;

    public LeaseCreationLock lock(int lockRow) throws StorageException {
        int readID = this.readRow(lockRow);
        if (readID == -1) {
            throw new StorageException("Cluster misconfiguration. Lease creation lock row not found");
        }
        return new LeaseCreationLock(readID);
    }

    public void createLockRows(int count) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        for (int i = 0; i < count; ++i) {
            int readID = this.readRow(i);
            if (readID != -1) continue;
            LeaseCreationLockDTO dto = session.newInstance(LeaseCreationLockDTO.class);
            dto.setID(i);
            session.savePersistent(dto);
            session.release(dto);
            LOG.debug((Object)("Added lease creation lock row with ID: " + i));
        }
    }

    private int readRow(int rowID) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        LeaseCreationLockDTO dto = session.find(LeaseCreationLockDTO.class, rowID);
        int readID = -1;
        if (dto != null) {
            readID = dto.getID();
            session.release(dto);
        }
        return readID;
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(LeaseCreationLockDTO.class);
    }

    @PersistenceCapable(table="hdfs_lease_creation_locks")
    public static interface LeaseCreationLockDTO {
        @PrimaryKey
        @Column(name="id")
        public int getID();

        public void setID(int var1);
    }
}

