/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.metadata.hdfs.entity.PendingBlockInfo;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsPredicateOperand;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class PendingBlockClusterj
implements TablesDef.PendingBlockTableDef,
PendingBlockDataAccess<PendingBlockInfo> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public int countValidPendingBlocks(long timeLimit) throws StorageException {
        return MySQLQueryHelper.countUniqueWithCriterion("hdfs_pending_blocks", String.format("%s, %s", "inode_id", "block_id"), String.format("%s>%d", "time_stamp", timeLimit));
    }

    public List<PendingBlockInfo> findByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingBlockDTO> qdt = qb.createQueryDefinition(PendingBlockDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").equal(qdt.param("idParam"));
        qdt.where(pred1);
        HopsQuery<PendingBlockDTO> query = session.createQuery(qdt);
        query.setParameter("idParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<PendingBlockInfo> findByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingBlockDTO> qdt = qb.createQueryDefinition(PendingBlockDTO.class);
        HopsPredicate pred1 = qdt.get("iNodeId").in(qdt.param("idParam"));
        qdt.where(pred1);
        HopsQuery<PendingBlockDTO> query = session.createQuery(qdt);
        query.setParameter("idParam", Longs.asList((long[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<PendingBlockInfo> removed, Collection<PendingBlockInfo> newed, Collection<PendingBlockInfo> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<PendingBlockDTO> changes = new ArrayList<PendingBlockDTO>();
        ArrayList<PendingBlockDTO> deletions = new ArrayList<PendingBlockDTO>();
        try {
            PendingBlockDTO pTable;
            for (PendingBlockInfo p : newed) {
                changes.addAll(this.createPersistableHopPendingBlockInfo(p, session));
            }
            for (PendingBlockInfo p : modified) {
                pTable = session.newInstance(PendingBlockDTO.class);
                changes.addAll(this.createPersistableHopPendingBlockInfo(p, session));
            }
            for (PendingBlockInfo p : removed) {
                pTable = session.newInstance(PendingBlockDTO.class);
                deletions.addAll(this.createPersistableHopPendingBlockInfo(p, session));
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public PendingBlockInfo findByBlockAndInodeIds(long blockId, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingBlockDTO> dobj = qb.createQueryDefinition(PendingBlockDTO.class);
        HopsPredicate pred = dobj.get("iNodeId").equal(dobj.param("iNodeId"));
        dobj.where(pred);
        pred = dobj.get("blockId").equal(dobj.param("blockId"));
        dobj.where(pred);
        HopsQuery<PendingBlockDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeId", inodeId);
        query.setParameter("blockId", blockId);
        List<PendingBlockDTO> dtos = query.getResultList();
        if (dtos == null || dtos.isEmpty()) {
            return null;
        }
        return this.convertAndRelease(session, dtos, blockId, inodeId, dtos.get(0).getTimestamp());
    }

    public List<PendingBlockInfo> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<PendingBlockDTO> query = session.createQuery(qb.createQueryDefinition(PendingBlockDTO.class));
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<PendingBlockInfo> findByTimeLimitLessThan(long timeLimit) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PendingBlockDTO> qdt = qb.createQueryDefinition(PendingBlockDTO.class);
        HopsPredicateOperand predicateOp = qdt.get("timestamp");
        String paramName = "timelimit";
        HopsPredicateOperand param = qdt.param(paramName);
        HopsPredicate lessThan = predicateOp.lessThan(param);
        qdt.where(lessThan);
        HopsQuery<PendingBlockDTO> query = session.createQuery(qdt);
        query.setParameter(paramName, timeLimit);
        return this.convertAndRelease(session, query.getResultList());
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(PendingBlockDTO.class);
    }

    private List<PendingBlockInfo> convertAndRelease(HopsSession session, Collection<PendingBlockDTO> dtos) throws StorageException {
        HashMap pendingBlocks = new HashMap();
        for (PendingBlockDTO dto : dtos) {
            ArrayList<PendingBlockDTO> pending;
            HashMap<Long, ArrayList<PendingBlockDTO>> inodePendingBlocks = (HashMap<Long, ArrayList<PendingBlockDTO>>)pendingBlocks.get(dto.getINodeId());
            if (inodePendingBlocks == null) {
                inodePendingBlocks = new HashMap<Long, ArrayList<PendingBlockDTO>>();
                pendingBlocks.put(dto.getINodeId(), inodePendingBlocks);
            }
            if ((pending = (ArrayList<PendingBlockDTO>)inodePendingBlocks.get(dto.getBlockId())) == null) {
                pending = new ArrayList<PendingBlockDTO>();
                inodePendingBlocks.put(dto.getBlockId(), pending);
            }
            pending.add(dto);
        }
        ArrayList<PendingBlockInfo> list = new ArrayList<PendingBlockInfo>();
        for (HashMap<Long, ArrayList<PendingBlockDTO>> inodePendingBlocks : pendingBlocks.values()) {
            for (List pending : inodePendingBlocks.values()) {
                list.add(this.convertAndRelease(session, pending, ((PendingBlockDTO)pending.get(0)).getBlockId(), ((PendingBlockDTO)pending.get(0)).getINodeId(), ((PendingBlockDTO)pending.get(0)).getINodeId()));
            }
        }
        return list;
    }

    private PendingBlockInfo convertAndRelease(HopsSession session, List<PendingBlockDTO> pendingTables, long blockId, long nodeId, long timestamp) throws StorageException {
        ArrayList<String> targets = new ArrayList<String>();
        for (PendingBlockDTO pendingTable : pendingTables) {
            if (pendingTable.getTarget() == null || pendingTable.getTarget().isEmpty()) continue;
            targets.add(pendingTable.getTarget());
        }
        PendingBlockDTO pendingTable = pendingTables.get(0);
        PendingBlockInfo pendingBlockInfo = new PendingBlockInfo(blockId, nodeId, timestamp, targets);
        session.release(pendingTables);
        return pendingBlockInfo;
    }

    private List<PendingBlockDTO> createPersistableHopPendingBlockInfo(PendingBlockInfo pendingBlock, HopsSession session) throws StorageException {
        ArrayList<PendingBlockDTO> persistables = new ArrayList<PendingBlockDTO>();
        if (pendingBlock.getTargets() == null || pendingBlock.getTargets().size() == 0) {
            PendingBlockDTO persistable = session.newInstance(PendingBlockDTO.class);
            persistable.setBlockId(pendingBlock.getBlockId());
            persistable.setTimestamp(pendingBlock.getTimeStamp());
            persistable.setINodeId(pendingBlock.getInodeId());
            persistable.setTarget("");
            persistables.add(persistable);
        } else {
            for (String dnId : pendingBlock.getTargets()) {
                PendingBlockDTO persistable = session.newInstance(PendingBlockDTO.class);
                persistable.setBlockId(pendingBlock.getBlockId());
                persistable.setTarget(dnId);
                persistable.setTimestamp(pendingBlock.getTimeStamp());
                persistable.setINodeId(pendingBlock.getInodeId());
                persistables.add(persistable);
            }
        }
        return persistables;
    }

    @PersistenceCapable(table="hdfs_pending_blocks")
    @PartitionKey(column="inode_id")
    public static interface PendingBlockDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @Column(name="time_stamp")
        public long getTimestamp();

        public void setTimestamp(long var1);

        @Column(name="target")
        public String getTarget();

        public void setTarget(String var1);
    }
}

