/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.rmstatestore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.ReservationStateDataAccess;
import io.hops.metadata.yarn.entity.rmstatestore.ReservationState;
import java.util.ArrayList;
import java.util.List;

public class ReservationStateClusterJ
implements TablesDef.ReservationStateTableDef,
ReservationStateDataAccess<ReservationState> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<ReservationState> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReservationStateDTO> dobj = qb.createQueryDefinition(ReservationStateDTO.class);
        HopsQuery<ReservationStateDTO> query = session.createQuery(dobj);
        List<ReservationStateDTO> queryResults = query.getResultList();
        List<ReservationState> result = this.createList(queryResults);
        session.release(queryResults);
        return result;
    }

    public void add(ReservationState state) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ReservationStateDTO toModify = this.createPersistable(state, session);
        session.savePersistent(toModify);
        session.release(toModify);
    }

    public void remove(ReservationState state) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ReservationStateDTO toRemove = this.createPersistable(state, session);
        session.deletePersistent(toRemove);
        session.release(toRemove);
    }

    private ReservationStateDTO createPersistable(ReservationState hop, HopsSession session) throws StorageException {
        ReservationStateDTO dto = session.newInstance(ReservationStateDTO.class);
        dto.setPlanName(hop.getPlanName());
        dto.setReservationIdName(hop.getReservationIdName());
        dto.setReservationState(hop.getState());
        return dto;
    }

    private List<ReservationState> createList(List<ReservationStateDTO> results) {
        ArrayList<ReservationState> reservationStates = new ArrayList<ReservationState>(results.size());
        for (ReservationStateDTO persistable : results) {
            reservationStates.add(this.createReservationState(persistable));
        }
        return reservationStates;
    }

    private ReservationState createReservationState(ReservationStateDTO dto) {
        return new ReservationState(dto.getReservationState(), dto.getPlanName(), dto.getReservationIdName());
    }

    @PersistenceCapable(table="yarn_reservation_state")
    public static interface ReservationStateDTO {
        @PrimaryKey
        @Column(name="plan_name")
        public String getPlanName();

        public void setPlanName(String var1);

        @PrimaryKey
        @Column(name="reservation_id_name")
        public String getReservationIdName();

        public void setReservationIdName(String var1);

        @PrimaryKey
        @Column(name="state")
        public byte[] getReservationState();

        public void setReservationState(byte[] var1);
    }
}

