/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RetryCacheEntryClusterj
implements TablesDef.RetryCacheEntryTableDef,
RetryCacheEntryDataAccess<RetryCacheEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public RetryCacheEntry find(RetryCacheEntry.PrimaryKey key) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        Object[] pk = new Object[]{key.getClientId(), key.getCallId(), key.getEpoch()};
        RetryCacheEntryDTO result = session.find(RetryCacheEntryDTO.class, pk);
        if (result != null) {
            RetryCacheEntry retryCacheEntry = this.convert(result);
            session.release(result);
            return retryCacheEntry;
        }
        return null;
    }

    public void prepare(Collection<RetryCacheEntry> removed, Collection<RetryCacheEntry> modified) throws StorageException {
        RetryCacheEntryDTO newInstance;
        ArrayList<RetryCacheEntryDTO> changes = new ArrayList<RetryCacheEntryDTO>();
        ArrayList<RetryCacheEntryDTO> deletions = new ArrayList<RetryCacheEntryDTO>();
        HopsSession session = this.connector.obtainSession();
        for (RetryCacheEntry retryCacheEntry : removed) {
            newInstance = session.newInstance(RetryCacheEntryDTO.class);
            this.createPersistable(retryCacheEntry, newInstance);
            deletions.add(newInstance);
        }
        for (RetryCacheEntry retryCacheEntry : modified) {
            newInstance = session.newInstance(RetryCacheEntryDTO.class);
            this.createPersistable(retryCacheEntry, newInstance);
            changes.add(newInstance);
        }
        session.deletePersistentAll(deletions);
        session.savePersistentAll(changes);
        session.release(deletions);
        session.release(changes);
    }

    public int removeOlds(long epoch) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<RetryCacheEntryDTO> qdt = qb.createQueryDefinition(RetryCacheEntryDTO.class);
        qdt.where(qdt.get("epoch").equal(qdt.param("param")));
        HopsQuery<RetryCacheEntryDTO> query = session.createQuery(qdt);
        query.setParameter("param", epoch);
        return query.deletePersistentAll();
    }

    public int count() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_retry_cache_entry");
    }

    public List<RetryCacheEntry> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<RetryCacheEntryDTO> query = session.createQuery(qb.createQueryDefinition(RetryCacheEntryDTO.class));
        List<RetryCacheEntryDTO> dtos = query.getResultList();
        List<RetryCacheEntry> list = this.convert(dtos);
        session.release(dtos);
        return list;
    }

    private List<RetryCacheEntry> convert(List<RetryCacheEntryDTO> list) throws StorageException {
        ArrayList<RetryCacheEntry> retList = new ArrayList<RetryCacheEntry>();
        for (RetryCacheEntryDTO persistable : list) {
            retList.add(this.convert(persistable));
        }
        return retList;
    }

    private RetryCacheEntry convert(RetryCacheEntryDTO result) {
        return new RetryCacheEntry(result.getClientId(), result.getCallId(), result.getPayload(), result.getExpirationTime(), result.getEpoch(), result.getState());
    }

    private void createPersistable(RetryCacheEntry retryCacheEntry, RetryCacheEntryDTO newInstance) {
        newInstance.setClientId(retryCacheEntry.getClientId());
        newInstance.setCallId(retryCacheEntry.getCallId());
        newInstance.setPayload(retryCacheEntry.getPayload());
        newInstance.setExpirationTime(retryCacheEntry.getExpirationTime());
        newInstance.setState(retryCacheEntry.getState());
        newInstance.setEpoch(retryCacheEntry.getEpoch());
    }

    @PersistenceCapable(table="hdfs_retry_cache_entry")
    @PartitionKey(column="epoch")
    public static interface RetryCacheEntryDTO {
        @PrimaryKey
        @Column(name="client_id")
        public byte[] getClientId();

        public void setClientId(byte[] var1);

        @PrimaryKey
        @Column(name="call_id")
        public int getCallId();

        public void setCallId(int var1);

        @Column(name="payload")
        public byte[] getPayload();

        public void setPayload(byte[] var1);

        @Column(name="expiration_time")
        public long getExpirationTime();

        public void setExpirationTime(long var1);

        @PrimaryKey
        @Column(name="epoch")
        public long getEpoch();

        public void setEpoch(long var1);

        @Column(name="state")
        public byte getState();

        public void setState(byte var1);
    }
}

