/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.FileProvenanceDataAccess;
import io.hops.metadata.hdfs.entity.FileProvenanceEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;

public class FileProvenanceClusterj
implements TablesDef.FileProvenanceTableDef,
FileProvenanceDataAccess<FileProvenanceEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<FileProvenanceEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ProvenanceLogEntryDto> added = new ArrayList<ProvenanceLogEntryDto>(logEntries.size());
        try {
            for (FileProvenanceEntry logEntry : logEntries) {
                added.add(this.createPersistable(logEntry));
            }
            session.savePersistentAll(added);
        }
        finally {
            session.release(added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FileProvenanceEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ProvenanceLogEntryDto dto = null;
        try {
            dto = this.createPersistable(logEntry);
            session.savePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    private ProvenanceLogEntryDto createPersistable(FileProvenanceEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ProvenanceLogEntryDto dto = session.newInstance(ProvenanceLogEntryDto.class);
        dto.setInodeId(logEntry.getInodeId());
        dto.setOperation(logEntry.getOperation());
        dto.setLogicalTime(logEntry.getLogicalTime());
        dto.setTimestamp(logEntry.getTimestamp());
        dto.setAppId(logEntry.getAppId());
        dto.setUserId(logEntry.getUserId());
        dto.setTieBreaker(logEntry.getTieBreaker());
        dto.setPartitionId(logEntry.getPartitionId());
        dto.setProjectId(logEntry.getProjectId());
        dto.setDatasetId(logEntry.getDatasetId());
        dto.setParentId(logEntry.getParentId());
        dto.setInodeName(logEntry.getInodeName());
        dto.setProjectName(logEntry.getProjectName());
        dto.setDatasetName(logEntry.getDatasetName());
        dto.setP1Name(logEntry.getP1Name());
        dto.setP2Name(logEntry.getP2Name());
        dto.setParentName(logEntry.getParentName());
        dto.setUserName(logEntry.getUserName());
        dto.setXAttrName(logEntry.getXattrName());
        dto.setLogicalTimeBatch(logEntry.getLogicalTimeBatch());
        dto.setTimestampBatch(logEntry.getTimestampBatch());
        dto.setDsLogicalTime(logEntry.getDsLogicalTime());
        dto.setXAttrNumParts(logEntry.getXattrNumParts());
        return dto;
    }

    @PersistenceCapable(table="hdfs_file_provenance_log")
    public static interface ProvenanceLogEntryDto {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @PrimaryKey
        @Column(name="inode_operation")
        public String getOperation();

        public void setOperation(String var1);

        @PrimaryKey
        @Column(name="io_logical_time")
        public int getLogicalTime();

        public void setLogicalTime(int var1);

        @PrimaryKey
        @Column(name="io_timestamp")
        public long getTimestamp();

        public void setTimestamp(long var1);

        @PrimaryKey
        @Column(name="io_app_id")
        public String getAppId();

        public void setAppId(String var1);

        @PrimaryKey
        @Column(name="io_user_id")
        public int getUserId();

        public void setUserId(int var1);

        @PrimaryKey
        @Column(name="tb")
        public String getTieBreaker();

        public void setTieBreaker(String var1);

        @Column(name="i_partition_id")
        public long getPartitionId();

        public void setPartitionId(long var1);

        @Column(name="project_i_id")
        public long getProjectId();

        public void setProjectId(long var1);

        @Column(name="dataset_i_id")
        public long getDatasetId();

        public void setDatasetId(long var1);

        @Column(name="parent_i_id")
        public long getParentId();

        public void setParentId(long var1);

        @Column(name="i_name")
        public String getInodeName();

        public void setInodeName(String var1);

        @Column(name="project_name")
        public String getProjectName();

        public void setProjectName(String var1);

        @Column(name="dataset_name")
        public String getDatasetName();

        public void setDatasetName(String var1);

        @Column(name="i_p1_name")
        public String getP1Name();

        public void setP1Name(String var1);

        @Column(name="i_p2_name")
        public String getP2Name();

        public void setP2Name(String var1);

        @Column(name="i_parent_name")
        public String getParentName();

        public void setParentName(String var1);

        @Column(name="io_user_name")
        public String getUserName();

        public void setUserName(String var1);

        @Column(name="i_xattr_name")
        public String getXAttrName();

        public void setXAttrName(String var1);

        @Column(name="io_logical_time_batch")
        public int getLogicalTimeBatch();

        public void setLogicalTimeBatch(int var1);

        @Column(name="io_timestamp_batch")
        public long getTimestampBatch();

        public void setTimestampBatch(long var1);

        @Column(name="ds_logical_time")
        public int getDsLogicalTime();

        public void setDsLogicalTime(int var1);

        @Column(name="i_xattr_num_parts")
        public short getXAttrNumParts();

        public void setXAttrNumParts(short var1);
    }
}

