/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.configurationstore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.dal.ConfDataAccess;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import java.util.ArrayList;
import java.util.List;

public class ConfClusterJ
implements TablesDef.ConfTableDef,
ConfDataAccess<byte[]> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public byte[] get() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ConfDTO> dobj = qb.createQueryDefinition(ConfDTO.class);
        HopsQuery<ConfDTO> query = session.createQuery(dobj);
        List<ConfDTO> queryResults = query.getResultList();
        byte[] result = this.create(queryResults);
        session.release(queryResults);
        return result;
    }

    public void set(byte[] conf) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(ConfDTO.class);
        ConfDTO toAdd = this.createPersistable(conf, session);
        session.savePersistent(toAdd);
        session.release(toAdd);
    }

    private ConfDTO createPersistable(byte[] conf, HopsSession session) throws StorageException {
        ConfDTO dto = session.newInstance(ConfDTO.class);
        dto.setIndex(0);
        dto.setConf(conf);
        return dto;
    }

    private byte[] create(List<ConfDTO> results) {
        ArrayList<byte[]> reservationStates = new ArrayList<byte[]>(results.size());
        for (ConfDTO persistable : results) {
            if (persistable == null) continue;
            reservationStates.add(persistable.getIndex(), persistable.getConf());
        }
        if (reservationStates.isEmpty()) {
            return null;
        }
        return (byte[])reservationStates.get(0);
    }

    @PersistenceCapable(table="yarn_conf")
    public static interface ConfDTO {
        @PrimaryKey
        @Column(name="index")
        public int getIndex();

        public void setIndex(int var1);

        @Column(name="conf")
        public byte[] getConf();

        public void setConf(byte[] var1);
    }
}

