/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.configurationstore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.dal.ConfMutationDataAccess;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import java.util.ArrayList;
import java.util.List;

public class ConfMutationClusterJ
implements TablesDef.ConfMutationTableDef,
ConfMutationDataAccess<byte[]> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public List<byte[]> get() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ConfMutationDTO> dobj = qb.createQueryDefinition(ConfMutationDTO.class);
        HopsQuery<ConfMutationDTO> query = session.createQuery(dobj);
        List<ConfMutationDTO> queryResults = query.getResultList();
        List<byte[]> result = this.createList(queryResults);
        session.release(queryResults);
        return result;
    }

    public void set(List<byte[]> mutations) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(ConfMutationDTO.class);
        List<ConfMutationDTO> toAdd = this.createPersistable(mutations, session);
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    private List<ConfMutationDTO> createPersistable(List<byte[]> mutations, HopsSession session) throws StorageException {
        ArrayList<ConfMutationDTO> dtos = new ArrayList<ConfMutationDTO>();
        int i = 0;
        for (byte[] mutation : mutations) {
            ConfMutationDTO dto = session.newInstance(ConfMutationDTO.class);
            dto.setIndex(i);
            dto.setMutation(mutation);
            ++i;
            dtos.add(dto);
        }
        return dtos;
    }

    private List<byte[]> createList(List<ConfMutationDTO> results) {
        ArrayList<byte[]> reservationStates = new ArrayList<byte[]>(results.size());
        for (ConfMutationDTO persistable : results) {
            reservationStates.add(persistable.getIndex(), persistable.getMutation());
        }
        return reservationStates;
    }

    @PersistenceCapable(table="yarn_conf_mutation")
    public static interface ConfMutationDTO {
        @PrimaryKey
        @Column(name="index")
        public int getIndex();

        public void setIndex(int var1);

        @Column(name="mutation")
        public byte[] getMutation();

        public void setMutation(byte[] var1);
    }
}

