/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.hdfs.entity.StoredXAttr;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XAttrClusterJ
implements TablesDef.XAttrTableDef,
XAttrDataAccess<StoredXAttr, StoredXAttr.PrimaryKey> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private short NON_EXISTS_XATTR = (short)-1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoredXAttr> getXAttrsByPrimaryKeyBatch(List<StoredXAttr.PrimaryKey> pks) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList dtos = Lists.newArrayListWithExpectedSize((int)pks.size());
        ArrayList partsDtos = Lists.newArrayListWithCapacity((int)pks.size());
        try {
            short index = 0;
            for (StoredXAttr.PrimaryKey pk : pks) {
                XAttrDTO dto = session.newInstance(XAttrDTO.class, new Object[]{pk.getInodeId(), pk.getNamespace(), pk.getName(), index});
                dto.setNumParts(this.NON_EXISTS_XATTR);
                session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            while (!dtos.isEmpty()) {
                XAttrDTO dto = (XAttrDTO)dtos.remove(0);
                if (dto.getNumParts() == this.NON_EXISTS_XATTR) continue;
                ArrayList pdtos = Lists.newArrayListWithExpectedSize((int)dto.getNumParts());
                pdtos.add(dto);
                for (short i = 1; i < dto.getNumParts(); i = (short)(i + 1)) {
                    XAttrDTO partDto = session.newInstance(XAttrDTO.class, new Object[]{dto.getINodeId(), dto.getNamespace(), dto.getName(), i});
                    partDto.setNumParts(this.NON_EXISTS_XATTR);
                    session.load(partDto);
                    pdtos.add(partDto);
                }
                partsDtos.add(pdtos);
            }
            session.flush();
            List<StoredXAttr> list = this.convertBatch(session, partsDtos);
            return list;
        }
        finally {
            if (!dtos.isEmpty()) {
                session.release(dtos);
            }
            for (List dtoList : partsDtos) {
                session.release(dtoList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StoredXAttr> getXAttrsByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<XAttrDTO> dobj = qb.createQueryDefinition(XAttrDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<XAttrDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", inodeId);
        List<XAttrDTO> results = null;
        try {
            results = query.getResultList();
            if (results.isEmpty()) {
                Collection<StoredXAttr> collection = null;
                return collection;
            }
            List<StoredXAttr> list = this.convertByInode(session, results);
            return list;
        }
        finally {
            session.release(results);
        }
    }

    public int removeXAttrsByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<XAttrDTO> dobj = qb.createQueryDefinition(XAttrDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("idParam"));
        dobj.where(pred1);
        HopsQuery<XAttrDTO> query = session.createQuery(dobj);
        query.setParameter("idParam", inodeId);
        return query.deletePersistentAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<StoredXAttr> removed, Collection<StoredXAttr> newed, Collection<StoredXAttr> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<XAttrDTO> changes = new ArrayList<XAttrDTO>();
        ArrayList<XAttrDTO> deletions = new ArrayList<XAttrDTO>();
        try {
            List<XAttrDTO> xdeletions;
            List<XAttrDTO> persistables;
            for (StoredXAttr xattr : removed) {
                persistables = this.createPersistable(session, xattr);
                deletions.addAll(persistables);
            }
            for (StoredXAttr xattr : newed) {
                persistables = this.createPersistable(session, xattr);
                xdeletions = this.createExtraDeletionPersistables(session, xattr);
                deletions.addAll(xdeletions);
                changes.addAll(persistables);
            }
            for (StoredXAttr xattr : modified) {
                persistables = this.createPersistable(session, xattr);
                xdeletions = this.createExtraDeletionPersistables(session, xattr);
                deletions.addAll(xdeletions);
                changes.addAll(persistables);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public int count() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_xattrs");
    }

    private List<XAttrDTO> createPersistable(HopsSession session, StoredXAttr xattr) throws StorageException {
        ArrayList<XAttrDTO> xAttrDTOS = new ArrayList<XAttrDTO>();
        short numParts = xattr.getNumParts();
        for (short index = 0; index < numParts; index = (short)(index + 1)) {
            XAttrDTO dto = session.newInstance(XAttrDTO.class);
            dto.setINodeId(xattr.getInodeId());
            dto.setNamespace(xattr.getNamespace());
            dto.setName(xattr.getName());
            dto.setValue(xattr.getValue(index));
            dto.setIndex(index);
            dto.setNumParts(numParts);
            xAttrDTOS.add(dto);
        }
        return xAttrDTOS;
    }

    private List<XAttrDTO> createExtraDeletionPersistables(HopsSession session, StoredXAttr xattr) throws StorageException {
        ArrayList<XAttrDTO> xAttrDTOS = new ArrayList<XAttrDTO>();
        if (xattr.getOldNumParts() > 0 && xattr.getNumParts() < xattr.getOldNumParts()) {
            for (short index = xattr.getNumParts(); index < xattr.getOldNumParts(); index = (short)(index + 1)) {
                XAttrDTO dto = session.newInstance(XAttrDTO.class);
                dto.setINodeId(xattr.getInodeId());
                dto.setNamespace(xattr.getNamespace());
                dto.setName(xattr.getName());
                dto.setIndex(index);
                xAttrDTOS.add(dto);
            }
        }
        return xAttrDTOS;
    }

    private List<StoredXAttr> convertBatch(HopsSession session, List<List<XAttrDTO>> dtos) throws StorageException {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)dtos.size());
        for (List<XAttrDTO> dtoList : dtos) {
            results.add(this.convert(session, dtoList));
        }
        return results;
    }

    private List<StoredXAttr> convertByInode(HopsSession session, List<XAttrDTO> dtos) throws StorageException {
        ArrayList results = Lists.newArrayList();
        HashMap xAttrsByPk = new HashMap();
        for (XAttrDTO xAttrDTO : dtos) {
            StoredXAttr.PrimaryKey pk = new StoredXAttr.PrimaryKey(xAttrDTO.getINodeId(), xAttrDTO.getNamespace(), xAttrDTO.getName());
            if (!xAttrsByPk.containsKey(pk)) {
                xAttrsByPk.put(pk, new ArrayList());
            }
            ((List)xAttrsByPk.get(pk)).add(xAttrDTO);
        }
        for (Map.Entry entry : xAttrsByPk.entrySet()) {
            List xAttrDTOS = (List)entry.getValue();
            Collections.sort(xAttrDTOS, new Comparator<XAttrDTO>(){

                @Override
                public int compare(XAttrDTO o1, XAttrDTO o2) {
                    return Short.compare(o1.getIndex(), o2.getIndex());
                }
            });
            results.add(this.convert(session, xAttrDTOS));
        }
        return results;
    }

    private StoredXAttr convert(HopsSession session, List<XAttrDTO> dtos) throws StorageException {
        byte[] value;
        byte[][] values = new byte[dtos.size()][];
        short index = 0;
        int nulls = 0;
        for (XAttrDTO dto : dtos) {
            if (dto.getNumParts() != this.NON_EXISTS_XATTR) {
                values[index] = dto.getValue();
            } else {
                XAttrDTO partDto = session.find(XAttrDTO.class, new Object[]{dto.getINodeId(), dto.getNamespace(), dto.getName(), index});
                values[index] = partDto.getValue();
            }
            if (values[index] == null) {
                ++nulls;
            }
            index = (short)(index + 1);
        }
        XAttrDTO dto = dtos.get(0);
        if (nulls == 0) {
            value = Bytes.concat((byte[][])values);
        } else if (nulls == dtos.size()) {
            value = null;
        } else {
            throw new IllegalStateException("Failed to read XAttr [ " + dto.getName() + " ] for Inode " + dto.getINodeId() + " because " + nulls + " parts were null.");
        }
        return new StoredXAttr(dto.getINodeId(), dto.getNamespace(), dto.getName(), value);
    }

    @PersistenceCapable(table="hdfs_xattrs")
    public static interface XAttrDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="namespace")
        public byte getNamespace();

        public void setNamespace(byte var1);

        @PrimaryKey
        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @PrimaryKey
        @Column(name="index")
        public short getIndex();

        public void setIndex(short var1);

        @Column(name="num_parts")
        public short getNumParts();

        public void setNumParts(short var1);

        @Column(name="value")
        public byte[] getValue();

        public void setValue(byte[] var1);
    }
}

