/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb;

import com.mysql.clusterj.LockMode;
import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.dal.HdfsLeDescriptorDataAccess;
import io.hops.metadata.election.dal.YarnLeDescriptorDataAccess;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.dal.ActiveBlockReportsDataAccess;
import io.hops.metadata.hdfs.dal.BlockChecksumDataAccess;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.dal.BlockLookUpDataAccess;
import io.hops.metadata.hdfs.dal.CacheDirectiveDataAccess;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.metadata.hdfs.dal.CachedBlockDataAccess;
import io.hops.metadata.hdfs.dal.ConfDataAccess;
import io.hops.metadata.hdfs.dal.ConfMutationDataAccess;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.dal.DirectoryWithQuotaFeatureDataAccess;
import io.hops.metadata.hdfs.dal.EncodingJobsDataAccess;
import io.hops.metadata.hdfs.dal.EncodingStatusDataAccess;
import io.hops.metadata.hdfs.dal.EncryptionZoneDataAccess;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.dal.FileProvXAttrBufferDataAccess;
import io.hops.metadata.hdfs.dal.FileProvenanceDataAccess;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.dal.InvalidateBlockDataAccess;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.LeaseCreationLocksDataAccess;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.dal.MediumOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.dal.MisReplicatedRangeQueueDataAccess;
import io.hops.metadata.hdfs.dal.OngoingSubTreeOpsDataAccess;
import io.hops.metadata.hdfs.dal.PendingBlockDataAccess;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.dal.RepairJobsDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaDataAccess;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.metadata.hdfs.dal.RetryCacheEntryDataAccess;
import io.hops.metadata.hdfs.dal.SafeBlocksDataAccess;
import io.hops.metadata.hdfs.dal.SmallOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.dal.StorageDataAccess;
import io.hops.metadata.hdfs.dal.StorageIdMapDataAccess;
import io.hops.metadata.hdfs.dal.UnderReplicatedBlockDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.hdfs.dal.XAttrDataAccess;
import io.hops.metadata.ndb.DBSession;
import io.hops.metadata.ndb.DBSessionProvider;
import io.hops.metadata.ndb.dalimpl.configurationstore.ConfClusterJ;
import io.hops.metadata.ndb.dalimpl.configurationstore.ConfMutationClusterJ;
import io.hops.metadata.ndb.dalimpl.election.HdfsLeaderClusterj;
import io.hops.metadata.ndb.dalimpl.election.YarnLeaderClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.AceClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.ActiveBlockReportsClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockChecksumClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockInfoClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.BlockLookUpClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.CacheDirectiveClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.CachePoolClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.CachedBlockClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.CorruptReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.DirectoryWithQuotaFeatureClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.EncodingJobsClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.EncodingStatusClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.EncryptionZoneClusterJ;
import io.hops.metadata.ndb.dalimpl.hdfs.ExcessReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.FileProvXAttrBufferClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.FileProvenanceClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.GroupClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.HashBucketClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.INodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.InMemoryFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.InvalidatedBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LargeOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LeaseClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LeaseCreationLocksClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.LeasePathClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.MediumOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.MetadataLogClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.MisReplicatedRangeQueueClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.OnGoingSubTreeOpsClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.PendingBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.QuotaUpdateClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.RepairJobsClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ReplicaClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.ReplicaUnderConstructionClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.RetryCacheEntryClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.SafeBlocksClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.SmallOnDiskFileInodeClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.StorageIdMapClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.StoragesClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.UnderReplicatedBlockClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.UserClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.UserGroupClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.VariableClusterj;
import io.hops.metadata.ndb.dalimpl.hdfs.XAttrClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.quota.PriceMultiplicatorClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.quota.ProjectQuotaClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.quota.ProjectsDailyCostClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.rmstatestore.ApplicationAttemptStateClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.rmstatestore.ApplicationStateClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.rmstatestore.DelegationKeyClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.rmstatestore.DelegationTokenClusterJ;
import io.hops.metadata.ndb.dalimpl.yarn.rmstatestore.ReservationStateClusterJ;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.ndb.wrapper.HopsTransaction;
import io.hops.metadata.yarn.dal.AppProvenanceDataAccess;
import io.hops.metadata.yarn.dal.ReservationStateDataAccess;
import io.hops.metadata.yarn.dal.quota.PriceMultiplicatorDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectQuotaDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectsDailyCostDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationAttemptStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationStateDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationKeyDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationTokenDataAccess;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterjConnector
implements StorageConnector<DBSession> {
    private static final ClusterjConnector instance = new ClusterjConnector();
    private static boolean isInitialized = false;
    private DBSessionProvider dbSessionProvider = null;
    static ThreadLocal<DBSession> sessions = new ThreadLocal();
    static final Log LOG = LogFactory.getLog(ClusterjConnector.class);
    private String clusterConnectString;
    private String databaseName;

    private ClusterjConnector() {
    }

    public static ClusterjConnector getInstance() {
        return instance;
    }

    public void setConfiguration(Properties conf) throws StorageException {
        if (isInitialized) {
            LOG.warn((Object)"SessionFactory is already initialized");
            return;
        }
        this.clusterConnectString = (String)conf.get("com.mysql.clusterj.connectstring");
        LOG.info((Object)("Database connect string: " + conf.get("com.mysql.clusterj.connectstring")));
        this.databaseName = (String)conf.get("com.mysql.clusterj.database");
        LOG.info((Object)("Database name: " + conf.get("com.mysql.clusterj.database")));
        LOG.info((Object)("Max Transactions: " + conf.get("com.mysql.clusterj.max.transactions")));
        this.dbSessionProvider = new DBSessionProvider(conf);
        isInitialized = true;
    }

    public HopsSession obtainSession() throws StorageException {
        DBSession dbSession = sessions.get();
        if (dbSession == null) {
            dbSession = this.dbSessionProvider.getSession();
            sessions.set(dbSession);
        }
        return dbSession.getSession();
    }

    public void returnSession(Exception ... e) throws StorageException {
        DBSession dbSession = sessions.get();
        if (dbSession != null) {
            sessions.remove();
            this.dbSessionProvider.returnSession(dbSession, e);
        }
    }

    public void beginTransaction() throws StorageException {
        HopsSession session = this.obtainSession();
        if (session.currentTransaction().isActive()) {
            LOG.fatal((Object)"Prevented starting transaction within a transaction.");
            throw new Error("Can not start Tx inside another Tx");
        }
        session.currentTransaction().begin();
    }

    public void commit() throws StorageException {
        HopsSession session = null;
        StorageException dbError = null;
        try {
            session = this.obtainSession();
            HopsTransaction tx = session.currentTransaction();
            if (!tx.isActive()) {
                throw new StorageException("Cannot commit, no active transaction");
            }
            tx.commit();
        }
        catch (StorageException e) {
            try {
                dbError = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.returnSession(new Exception[]{dbError});
                throw throwable;
            }
        }
        this.returnSession(new Exception[]{dbError});
    }

    public void rollback(Exception exception) throws StorageException {
        ArrayList<Throwable> allExceptions = new ArrayList<Throwable>();
        if (exception != null) {
            allExceptions.add(exception);
        }
        HopsSession session = null;
        try {
            session = this.obtainSession();
            HopsTransaction tx = session.currentTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (StorageException e) {
            allExceptions.add(e);
            throw e;
        }
        finally {
            LOG.debug((Object)("rolback return session.  errors count: " + allExceptions.size()));
            this.returnSession(allExceptions.toArray(new Exception[allExceptions.size()]));
        }
    }

    public boolean formatStorage() throws StorageException {
        return this.formatAll(true);
    }

    public boolean formatYarnStorage() throws StorageException {
        return this.formatYarn(true);
    }

    public boolean formatHDFSStorage() throws StorageException {
        return this.formatHDFS(true);
    }

    public boolean formatStorage(Class<? extends EntityDataAccess> ... das) throws StorageException {
        return this.format(true, das);
    }

    public boolean isTransactionActive() throws StorageException {
        return this.obtainSession().currentTransaction().isActive();
    }

    public void stopStorage() throws StorageException {
        this.dbSessionProvider.stop();
    }

    public void readLock() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.SHARED);
    }

    public void writeLock() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.EXCLUSIVE);
    }

    public void readCommitted() throws StorageException {
        HopsSession session = this.obtainSession();
        session.setLockMode(LockMode.READ_COMMITTED);
    }

    public void setPartitionKey(Class className, Object key) throws StorageException {
        Class cls = null;
        if (className == BlockInfoDataAccess.class) {
            cls = BlockInfoClusterj.BlockInfoDTO.class;
        } else if (className == PendingBlockDataAccess.class) {
            cls = PendingBlockClusterj.PendingBlockDTO.class;
        } else if (className == ReplicaUnderConstructionDataAccess.class) {
            cls = ReplicaUnderConstructionClusterj.ReplicaUcDTO.class;
        } else if (className == INodeDataAccess.class) {
            cls = INodeClusterj.InodeDTO.class;
        } else if (className == DirectoryWithQuotaFeatureDataAccess.class) {
            cls = DirectoryWithQuotaFeatureClusterj.INodeAttributesDTO.class;
        } else if (className == LeaseDataAccess.class) {
            cls = LeaseClusterj.LeaseDTO.class;
        } else if (className == LeasePathDataAccess.class) {
            cls = LeasePathClusterj.LeasePathsDTO.class;
        } else if (className == HdfsLeDescriptorDataAccess.class) {
            cls = HdfsLeaderClusterj.HdfsLeaderDTO.class;
        } else if (className == YarnLeDescriptorDataAccess.class) {
            cls = YarnLeaderClusterj.YarnLeaderDTO.class;
        } else if (className == ReplicaDataAccess.class) {
            cls = ReplicaClusterj.ReplicaDTO.class;
        } else if (className == CorruptReplicaDataAccess.class) {
            cls = CorruptReplicaClusterj.CorruptReplicaDTO.class;
        } else if (className == ExcessReplicaDataAccess.class) {
            cls = ExcessReplicaClusterj.ExcessReplicaDTO.class;
        } else if (className == InvalidateBlockDataAccess.class) {
            cls = InvalidatedBlockClusterj.InvalidateBlocksDTO.class;
        } else if (className == UnderReplicatedBlockDataAccess.class) {
            cls = UnderReplicatedBlockClusterj.UnderReplicatedBlocksDTO.class;
        } else if (className == VariableDataAccess.class) {
            cls = VariableClusterj.VariableDTO.class;
        } else if (className == QuotaUpdateDataAccess.class) {
            cls = QuotaUpdateClusterj.QuotaUpdateDTO.class;
        } else if (className == EncodingStatusDataAccess.class) {
            cls = EncodingStatusClusterj.EncodingStatusDto.class;
        } else if (className == BlockChecksumDataAccess.class) {
            cls = BlockChecksumClusterj.BlockChecksumDto.class;
        } else if (className == OngoingSubTreeOpsDataAccess.class) {
            cls = OnGoingSubTreeOpsClusterj.OnGoingSubTreeOpsDTO.class;
        } else if (className == HashBucketDataAccess.class) {
            cls = HashBucketClusterj.HashBucketDTO.class;
        } else if (className == InMemoryInodeDataAccess.class) {
            cls = InMemoryFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == SmallOnDiskInodeDataAccess.class) {
            cls = SmallOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == MediumOnDiskInodeDataAccess.class) {
            cls = MediumOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == LargeOnDiskInodeDataAccess.class) {
            cls = LargeOnDiskFileInodeClusterj.FileInodeDataDTO.class;
        } else if (className == AceDataAccess.class) {
            cls = AceClusterJ.AceDto.class;
        } else if (className == RetryCacheEntryDataAccess.class) {
            cls = RetryCacheEntryClusterj.RetryCacheEntryDTO.class;
        } else if (className == CacheDirectiveDataAccess.class) {
            cls = CacheDirectiveClusterj.CacheDirectiveDTO.class;
        } else if (className == CachePoolDataAccess.class) {
            cls = CachePoolClusterJ.CachePoolDTO.class;
        } else if (className == CachedBlockDataAccess.class) {
            cls = CachedBlockClusterJ.CachedBlockDTO.class;
        } else if (className == ActiveBlockReportsClusterj.class) {
            cls = ActiveBlockReportsClusterj.class;
        } else if (className == ConfMutationDataAccess.class) {
            cls = ConfMutationClusterJ.ConfMutationDTO.class;
        } else if (className == ConfDataAccess.class) {
            cls = ConfClusterJ.ConfDTO.class;
        } else if (className == LeaseCreationLocksDataAccess.class) {
            cls = LeaseCreationLocksClusterj.LeaseCreationLockDTO.class;
        }
        HopsSession session = this.obtainSession();
        session.setPartitionKey(cls, key);
        session.flush();
    }

    public boolean formatAllStorageNonTransactional() throws StorageException {
        return this.formatAll(false);
    }

    public boolean formatYarnStorageNonTransactional() throws StorageException {
        return this.formatAll(false);
    }

    public boolean formatHDFSStorageNonTransactional() throws StorageException {
        return this.formatHDFS(false);
    }

    private boolean formatYarn(boolean transactional) throws StorageException {
        return this.format(transactional, YarnLeDescriptorDataAccess.class, ApplicationStateDataAccess.class, ApplicationAttemptStateDataAccess.class, DelegationKeyDataAccess.class, DelegationTokenDataAccess.class, ProjectQuotaDataAccess.class, ProjectsDailyCostDataAccess.class, PriceMultiplicatorDataAccess.class, ReservationStateDataAccess.class, ConfMutationDataAccess.class, ConfDataAccess.class, AppProvenanceDataAccess.class);
    }

    private boolean formatHDFS(boolean transactional) throws StorageException {
        return this.format(transactional, INodeDataAccess.class, InMemoryInodeDataAccess.class, SmallOnDiskInodeDataAccess.class, MediumOnDiskInodeDataAccess.class, LargeOnDiskInodeDataAccess.class, BlockInfoDataAccess.class, LeaseDataAccess.class, LeasePathDataAccess.class, ReplicaDataAccess.class, ReplicaUnderConstructionDataAccess.class, InvalidateBlockDataAccess.class, ExcessReplicaDataAccess.class, PendingBlockDataAccess.class, CorruptReplicaDataAccess.class, UnderReplicatedBlockDataAccess.class, HdfsLeDescriptorDataAccess.class, DirectoryWithQuotaFeatureDataAccess.class, StorageIdMapDataAccess.class, BlockLookUpDataAccess.class, SafeBlocksDataAccess.class, MisReplicatedRangeQueueDataAccess.class, QuotaUpdateDataAccess.class, EncodingStatusDataAccess.class, BlockChecksumDataAccess.class, OngoingSubTreeOpsDataAccess.class, MetadataLogDataAccess.class, EncodingJobsDataAccess.class, RepairJobsDataAccess.class, UserDataAccess.class, GroupDataAccess.class, UserGroupDataAccess.class, VariableDataAccess.class, HashBucketDataAccess.class, StorageDataAccess.class, AceDataAccess.class, RetryCacheEntryDataAccess.class, CacheDirectiveDataAccess.class, CachePoolDataAccess.class, CachedBlockDataAccess.class, ActiveBlockReportsDataAccess.class, XAttrDataAccess.class, EncryptionZoneDataAccess.class, FileProvenanceDataAccess.class, FileProvXAttrBufferDataAccess.class, LeaseCreationLocksDataAccess.class);
    }

    private boolean formatAll(boolean transactional) throws StorageException {
        if (!this.formatHDFS(transactional)) {
            return false;
        }
        if (!this.formatYarn(transactional)) {
            return false;
        }
        return this.format(transactional, VariableDataAccess.class);
    }

    private boolean format(boolean transactional, Class<? extends EntityDataAccess> ... das) throws StorageException {
        int RETRIES = 5;
        if (!transactional) {
            this.dbSessionProvider.clearCache();
        }
        for (int i = 0; i < 5; ++i) {
            try {
                for (Class<? extends EntityDataAccess> e : das) {
                    if (e == StorageDataAccess.class) {
                        this.truncate(transactional, "hdfs_storages", StoragesClusterj.StorageDTO.class);
                        continue;
                    }
                    if (e == INodeDataAccess.class) {
                        this.truncate(transactional, "hdfs_inodes", INodeClusterj.InodeDTO.class);
                        continue;
                    }
                    if (e == InMemoryInodeDataAccess.class) {
                        this.truncate(transactional, "hdfs_inmemory_file_inode_data", InMemoryFileInodeClusterj.FileInodeDataDTO.class);
                        continue;
                    }
                    if (e == SmallOnDiskInodeDataAccess.class) {
                        this.truncate(transactional, "hdfs_ondisk_small_file_inode_data", SmallOnDiskFileInodeClusterj.FileInodeDataDTO.class);
                        continue;
                    }
                    if (e == MediumOnDiskInodeDataAccess.class) {
                        this.truncate(transactional, "hdfs_ondisk_medium_file_inode_data", MediumOnDiskFileInodeClusterj.FileInodeDataDTO.class);
                        continue;
                    }
                    if (e == LargeOnDiskInodeDataAccess.class) {
                        this.truncate(transactional, "hdfs_ondisk_large_file_inode_data", LargeOnDiskFileInodeClusterj.FileInodeDataDTO.class);
                        continue;
                    }
                    if (e == BlockInfoDataAccess.class) {
                        this.truncate(transactional, "hdfs_block_infos", BlockInfoClusterj.BlockInfoDTO.class);
                        continue;
                    }
                    if (e == LeaseDataAccess.class) {
                        this.truncate(transactional, "hdfs_leases", LeaseClusterj.LeaseDTO.class);
                        continue;
                    }
                    if (e == LeasePathDataAccess.class) {
                        this.truncate(transactional, "hdfs_lease_paths", LeasePathClusterj.LeasePathsDTO.class);
                        continue;
                    }
                    if (e == OngoingSubTreeOpsDataAccess.class) {
                        this.truncate(transactional, "hdfs_on_going_sub_tree_ops", OnGoingSubTreeOpsClusterj.OnGoingSubTreeOpsDTO.class);
                        continue;
                    }
                    if (e == ReplicaDataAccess.class) {
                        this.truncate(transactional, "hdfs_replicas", ReplicaClusterj.ReplicaDTO.class);
                        continue;
                    }
                    if (e == ReplicaUnderConstructionDataAccess.class) {
                        this.truncate(transactional, "hdfs_replica_under_constructions", ReplicaUnderConstructionClusterj.ReplicaUcDTO.class);
                        continue;
                    }
                    if (e == InvalidateBlockDataAccess.class) {
                        this.truncate(transactional, "hdfs_invalidated_blocks", InvalidatedBlockClusterj.InvalidateBlocksDTO.class);
                        continue;
                    }
                    if (e == ExcessReplicaDataAccess.class) {
                        this.truncate(transactional, "hdfs_excess_replicas", ExcessReplicaClusterj.ExcessReplicaDTO.class);
                        continue;
                    }
                    if (e == PendingBlockDataAccess.class) {
                        this.truncate(transactional, "hdfs_pending_blocks", PendingBlockClusterj.PendingBlockDTO.class);
                        continue;
                    }
                    if (e == CorruptReplicaDataAccess.class) {
                        this.truncate(transactional, "hdfs_corrupt_replicas", CorruptReplicaClusterj.CorruptReplicaDTO.class);
                        continue;
                    }
                    if (e == UnderReplicatedBlockDataAccess.class) {
                        this.truncate(transactional, "hdfs_under_replicated_blocks", UnderReplicatedBlockClusterj.UnderReplicatedBlocksDTO.class);
                        continue;
                    }
                    if (e == HdfsLeDescriptorDataAccess.class) {
                        this.truncate(transactional, "hdfs_le_descriptors", HdfsLeaderClusterj.HdfsLeaderDTO.class);
                        continue;
                    }
                    if (e == DirectoryWithQuotaFeatureDataAccess.class) {
                        this.truncate(transactional, "hdfs_directory_with_quota_feature", DirectoryWithQuotaFeatureClusterj.INodeAttributesDTO.class);
                        continue;
                    }
                    if (e == VariableDataAccess.class) {
                        HopsSession session = this.obtainSession();
                        session.currentTransaction().begin();
                        session.deletePersistentAll(VariableClusterj.VariableDTO.class);
                        for (Variable.Finder varType : Variable.Finder.values()) {
                            LOG.debug((Object)("write varialbe " + varType.name() + " with id " + varType.getId()));
                            VariableClusterj.VariableDTO vd = session.newInstance(VariableClusterj.VariableDTO.class);
                            vd.setId(varType.getId());
                            vd.setValue(varType.getDefaultValue());
                            session.savePersistent(vd);
                        }
                        session.currentTransaction().commit();
                        continue;
                    }
                    if (e == StorageIdMapDataAccess.class) {
                        this.truncate(transactional, "hdfs_storage_id_map", StorageIdMapClusterj.StorageIdDTO.class);
                        continue;
                    }
                    if (e == BlockLookUpDataAccess.class) {
                        this.truncate(transactional, "hdfs_block_lookup_table", BlockLookUpClusterj.BlockLookUpDTO.class);
                        continue;
                    }
                    if (e == SafeBlocksDataAccess.class) {
                        this.truncate(transactional, "hdfs_safe_blocks", SafeBlocksClusterj.SafeBlockDTO.class);
                        continue;
                    }
                    if (e == MisReplicatedRangeQueueDataAccess.class) {
                        this.truncate(transactional, "hdfs_misreplicated_range_queue", MisReplicatedRangeQueueClusterj.MisReplicatedRangeQueueDTO.class);
                        continue;
                    }
                    if (e == QuotaUpdateDataAccess.class) {
                        this.truncate(transactional, "hdfs_quota_update", QuotaUpdateClusterj.QuotaUpdateDTO.class);
                        continue;
                    }
                    if (e == EncodingStatusDataAccess.class) {
                        this.truncate(transactional, "hdfs_encoding_status", EncodingStatusClusterj.EncodingStatusDto.class);
                        continue;
                    }
                    if (e == BlockChecksumDataAccess.class) {
                        this.truncate(transactional, "hdfs_block_checksum", BlockChecksumClusterj.BlockChecksumDto.class);
                        continue;
                    }
                    if (e == MetadataLogDataAccess.class) {
                        this.truncate(transactional, "hdfs_metadata_log", MetadataLogClusterj.MetadataLogEntryDto.class);
                        this.truncate(transactional, "hdfs_inode_dataset_lookup", MetadataLogClusterj.DatasetINodeLookupDTO.class);
                        continue;
                    }
                    if (e == EncodingJobsDataAccess.class) {
                        this.truncate(transactional, "hdfs_encoding_jobs", EncodingJobsClusterj.EncodingJobDto.class);
                        continue;
                    }
                    if (e == RepairJobsDataAccess.class) {
                        this.truncate(transactional, "hdfs_repair_jobs", RepairJobsClusterj.RepairJobDto.class);
                        continue;
                    }
                    if (e == UserDataAccess.class) {
                        this.truncate(true, "hdfs_users", UserClusterj.UserDTO.class);
                        continue;
                    }
                    if (e == GroupDataAccess.class) {
                        this.truncate(true, "hdfs_groups", GroupClusterj.GroupDTO.class);
                        continue;
                    }
                    if (e == UserGroupDataAccess.class) {
                        this.truncate(transactional, "hdfs_users_groups", UserGroupClusterj.UserGroupDTO.class);
                        continue;
                    }
                    if (e == YarnLeDescriptorDataAccess.class) {
                        this.truncate(transactional, "yarn_le_descriptors", YarnLeaderClusterj.YarnLeaderDTO.class);
                        continue;
                    }
                    if (e == ApplicationAttemptStateDataAccess.class) {
                        this.truncate(transactional, "yarn_applicationattemptstate", ApplicationAttemptStateClusterJ.ApplicationAttemptStateDTO.class);
                        continue;
                    }
                    if (e == ApplicationStateDataAccess.class) {
                        this.truncate(transactional, "yarn_applicationstate", ApplicationStateClusterJ.ApplicationStateDTO.class);
                        continue;
                    }
                    if (e == DelegationKeyDataAccess.class) {
                        this.truncate(transactional, "yarn_delegation_key", DelegationKeyClusterJ.DelegationKeyDTO.class);
                        continue;
                    }
                    if (e == DelegationTokenDataAccess.class) {
                        this.truncate(transactional, "yarn_delegation_token", DelegationTokenClusterJ.DelegationTokenDTO.class);
                        continue;
                    }
                    if (e == ProjectQuotaDataAccess.class) {
                        this.truncate(transactional, "yarn_projects_quota", ProjectQuotaClusterJ.ProjectQuotaDTO.class);
                        continue;
                    }
                    if (e == ProjectsDailyCostDataAccess.class) {
                        this.truncate(transactional, "yarn_projects_daily_cost", ProjectsDailyCostClusterJ.ProjectDailyCostDTO.class);
                        continue;
                    }
                    if (e == PriceMultiplicatorDataAccess.class) {
                        this.truncate(transactional, "yarn_price_multiplicator", PriceMultiplicatorClusterJ.PriceMultiplicatorDTO.class);
                        continue;
                    }
                    if (e == HashBucketDataAccess.class) {
                        this.truncate(transactional, "hdfs_hash_buckets", HashBucketClusterj.HashBucketDTO.class);
                        continue;
                    }
                    if (e == ReservationStateDataAccess.class) {
                        this.truncate(transactional, "yarn_reservation_state", ReservationStateClusterJ.ReservationStateDTO.class);
                        continue;
                    }
                    if (e == AceDataAccess.class) {
                        this.truncate(transactional, "hdfs_aces", AceClusterJ.AceDto.class);
                        continue;
                    }
                    if (e == RetryCacheEntryDataAccess.class) {
                        this.truncate(transactional, "hdfs_retry_cache_entry", RetryCacheEntryClusterj.RetryCacheEntryDTO.class);
                        continue;
                    }
                    if (e == CacheDirectiveDataAccess.class) {
                        this.truncate(true, "hdfs_cache_directive", CacheDirectiveClusterj.CacheDirectiveDTO.class);
                        continue;
                    }
                    if (e == CachePoolDataAccess.class) {
                        this.truncate(transactional, "hdfs_cache_pool", CachePoolClusterJ.CachePoolDTO.class);
                        continue;
                    }
                    if (e == CachedBlockDataAccess.class) {
                        this.truncate(transactional, "hdfs_cached_block", CachedBlockClusterJ.CachedBlockDTO.class);
                        continue;
                    }
                    if (e == ActiveBlockReportsDataAccess.class) {
                        this.truncate(transactional, "hdfs_active_block_reports", ActiveBlockReportsClusterj.ActiveBlockReportDTO.class);
                        continue;
                    }
                    if (e == XAttrDataAccess.class) {
                        this.truncate(transactional, "hdfs_xattrs", XAttrClusterJ.XAttrDTO.class);
                        continue;
                    }
                    if (e == ConfMutationDataAccess.class) {
                        this.truncate(transactional, "yarn_conf_mutation", ConfMutationClusterJ.ConfMutationDTO.class);
                        continue;
                    }
                    if (e == ConfDataAccess.class) {
                        this.truncate(transactional, "yarn_conf", ConfClusterJ.ConfDTO.class);
                        continue;
                    }
                    if (e == EncryptionZoneDataAccess.class) {
                        this.truncate(transactional, "hdfs_encryption_zone", EncryptionZoneClusterJ.EncryptionZoneDTO.class);
                        continue;
                    }
                    if (e == FileProvenanceDataAccess.class) {
                        this.truncate(transactional, "hdfs_file_provenance_log", FileProvenanceClusterj.ProvenanceLogEntryDto.class);
                        continue;
                    }
                    if (e == FileProvXAttrBufferDataAccess.class) {
                        this.truncate(transactional, "hdfs_file_provenance_xattrs_buffer", FileProvXAttrBufferClusterj.FileProvXAttrBufferEntryDto.class);
                        continue;
                    }
                    if (e != LeaseCreationLocksDataAccess.class) continue;
                    this.truncate(transactional, "hdfs_lease_creation_locks", LeaseCreationLocksClusterj.LeaseCreationLockDTO.class);
                }
                MysqlServerConnector.truncateTable(transactional, "hdfs_path_memcached");
                return true;
            }
            catch (SQLException ex) {
                LOG.error((Object)ex.getMessage(), (Throwable)ex);
                continue;
            }
        }
        return false;
    }

    private void truncate(boolean transactional, String tableName, Class dtoClass) throws StorageException, SQLException {
        MysqlServerConnector.truncateTable(transactional, tableName);
        if (!transactional) {
            this.dbSessionProvider.getSession().getSession().unloadSchema(dtoClass);
        }
    }

    public void flush() throws StorageException {
        DBSession dbSession = sessions.get();
        if (dbSession == null) {
            dbSession = this.dbSessionProvider.getSession();
            sessions.set(dbSession);
        }
        dbSession.getSession().flush();
    }

    public String getClusterConnectString() {
        return this.clusterConnectString;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }
}

