/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.AppProvenanceDataAccess;
import io.hops.metadata.yarn.entity.AppProvenanceEntry;
import java.util.ArrayList;
import java.util.Collection;

public class AppProvenanceClusterJ
implements TablesDef.AppProvenanceTableDef,
AppProvenanceDataAccess<AppProvenanceEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<AppProvenanceEntry> entries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<AppProvenanceEntryDto> added = new ArrayList<AppProvenanceEntryDto>(entries.size());
        try {
            for (AppProvenanceEntry entry : entries) {
                added.add(this.createPersistable(entry));
            }
            session.savePersistentAll(added);
        }
        finally {
            session.release(added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AppProvenanceEntry entry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        AppProvenanceEntryDto dto = null;
        try {
            dto = this.createPersistable(entry);
            session.savePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    private AppProvenanceEntryDto createPersistable(AppProvenanceEntry entry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        AppProvenanceEntryDto dto = session.newInstance(AppProvenanceEntryDto.class);
        dto.setId(entry.getId());
        dto.setName(entry.getName());
        dto.setState(entry.getState());
        dto.setUser(entry.getUser());
        dto.setTimestamp(entry.getTimestamp());
        dto.setSubmitTime(entry.getSubmitTime());
        dto.setStartTime(entry.getStartTime());
        dto.setFinishTime(entry.getFinishTime());
        return dto;
    }

    @PersistenceCapable(table="yarn_app_provenance_log")
    public static interface AppProvenanceEntryDto {
        @PrimaryKey
        @Column(name="id")
        public String getId();

        public void setId(String var1);

        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @PrimaryKey
        @Column(name="state")
        public String getState();

        public void setState(String var1);

        @Column(name="user")
        public String getUser();

        public void setUser(String var1);

        @PrimaryKey
        @Column(name="timestamp")
        public long getTimestamp();

        public void setTimestamp(long var1);

        @PrimaryKey
        @Column(name="submit_time")
        public long getSubmitTime();

        public void setSubmitTime(long var1);

        @PrimaryKey
        @Column(name="start_time")
        public long getStartTime();

        public void setStartTime(long var1);

        @PrimaryKey
        @Column(name="finish_time")
        public long getFinishTime();

        public void setFinishTime(long var1);
    }
}

