/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.wrapper;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.SessionFactory;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.wrapper.ClusterJCaching;
import io.hops.metadata.ndb.wrapper.HopsExceptionHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.Map;

public class HopsSessionFactory {
    private final SessionFactory factory;
    private final ClusterJCaching clusterJCaching;

    public HopsSessionFactory(SessionFactory factory, ClusterJCaching clusterJCaching) {
        this.factory = factory;
        this.clusterJCaching = clusterJCaching;
    }

    public HopsSession getSession() throws StorageException {
        try {
            return new HopsSession(this.factory.getSession(), this.clusterJCaching);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public HopsSession getSession(Map map) throws StorageException {
        try {
            return new HopsSession(this.factory.getSession(map), this.clusterJCaching);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void close() throws StorageException {
        try {
            this.factory.close();
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public boolean isOpen() throws StorageException {
        try {
            return this.factory.currentState() == SessionFactory.State.Open;
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void reconnect() throws StorageException {
        try {
            this.factory.reconnect();
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }
}

