/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.wrapper;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.query.QueryBuilder;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.wrapper.ClusterJCaching;
import io.hops.metadata.ndb.wrapper.HopsExceptionHelper;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsTransaction;
import java.util.Collection;

public class HopsSession {
    private final Session session;
    private LockMode lockMode = LockMode.READ_COMMITTED;
    private final ClusterJCaching clusterJCaching;

    public HopsSession(Session session, ClusterJCaching clusterJCaching) {
        this.session = session;
        this.clusterJCaching = clusterJCaching;
    }

    public HopsQueryBuilder getQueryBuilder() throws StorageException {
        try {
            QueryBuilder queryBuilder = this.session.getQueryBuilder();
            return new HopsQueryBuilder(queryBuilder);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> HopsQuery<T> createQuery(HopsQueryDomainType<T> queryDefinition) throws StorageException {
        try {
            Query query = this.session.createQuery(queryDefinition.getQueryDomainType());
            return new HopsQuery(query);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T find(Class<T> aClass, Object o) throws StorageException {
        try {
            return (T)this.session.find(aClass, o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T newInstance(Class<T> aClass) throws StorageException {
        try {
            return (T)this.session.newInstance(aClass);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T newInstance(Class<T> aClass, Object o) throws StorageException {
        try {
            return (T)this.session.newInstance(aClass, o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T makePersistent(T t) throws StorageException {
        try {
            return (T)this.session.makePersistent(t);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T load(T t) throws StorageException {
        try {
            return (T)this.session.load(t);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public Boolean found(Object o) throws StorageException {
        try {
            return this.session.found(o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void persist(Object o) throws StorageException {
        try {
            this.session.persist(o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public Iterable<?> makePersistentAll(Iterable<?> iterable) throws StorageException {
        try {
            return this.session.makePersistentAll(iterable);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> void deletePersistent(Class<T> aClass, Object o) throws StorageException {
        try {
            this.session.deletePersistent(aClass, o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void deletePersistent(Object o) throws StorageException {
        try {
            this.session.deletePersistent(o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void remove(Object o) throws StorageException {
        try {
            this.session.remove(o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> int deletePersistentAll(Class<T> aClass) throws StorageException {
        try {
            return this.session.deletePersistentAll(aClass);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void deletePersistentAll(Iterable<?> iterable) throws StorageException {
        try {
            this.session.deletePersistentAll(iterable);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void updatePersistent(Object o) throws StorageException {
        try {
            this.session.updatePersistent(o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void updatePersistentAll(Iterable<?> iterable) throws StorageException {
        try {
            this.session.updatePersistentAll(iterable);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> T savePersistent(T t) throws StorageException {
        try {
            return (T)this.session.savePersistent(t);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public Iterable<?> savePersistentAll(Iterable<?> iterable) throws StorageException {
        try {
            return this.session.savePersistentAll(iterable);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public HopsTransaction currentTransaction() throws StorageException {
        try {
            Transaction transaction = this.session.currentTransaction();
            return new HopsTransaction(transaction);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void close() throws StorageException {
        try {
            if (this.clusterJCaching.useClusterjSessionCache()) {
                this.session.closeCache(true);
            } else {
                this.session.close();
            }
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public boolean isClosed() throws StorageException {
        try {
            return this.session.isClosed();
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void flush() throws StorageException {
        try {
            this.session.flush();
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void setPartitionKey(Class<?> aClass, Object o) throws StorageException {
        try {
            this.session.setPartitionKey(aClass, o);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void setLockMode(LockMode lockMode) throws StorageException {
        try {
            this.session.setLockMode(lockMode);
            this.lockMode = lockMode;
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void markModified(Object o, String s) throws StorageException {
        try {
            this.session.markModified(o, s);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public String unloadSchema(Class<?> aClass) throws StorageException {
        try {
            return this.session.unloadSchema(aClass);
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public void dropInstanceCache() throws StorageException {
        try {
            this.session.dropInstanceCache();
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> void release(T dto) throws StorageException {
        try {
            if (dto != null) {
                if (this.clusterJCaching.useClusterjDtoCache()) {
                    this.session.releaseCache(dto, dto.getClass());
                } else {
                    this.session.release(dto);
                }
            }
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public <T> void release(Collection<T> dtos) throws StorageException {
        try {
            if (dtos != null) {
                for (T dto : dtos) {
                    this.release(dto);
                }
            }
        }
        catch (ClusterJException e) {
            throw HopsExceptionHelper.wrap(e);
        }
    }

    public LockMode getCurrentLockMode() {
        return this.lockMode;
    }
}

