/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.MisReplicatedRangeQueueDataAccess;
import io.hops.metadata.hdfs.entity.MisReplicatedRange;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.List;

public class MisReplicatedRangeQueueClusterj
implements TablesDef.MisReplicatedRangeQueueTableDef,
MisReplicatedRangeQueueDataAccess {
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private static final String SEPERATOR = "-";

    public void insert(MisReplicatedRange range) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MisReplicatedRangeQueueDTO dto = null;
        try {
            dto = this.createPersistable(range, session);
            session.savePersistent(dto);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        finally {
            session.release(dto);
        }
    }

    public void remove(MisReplicatedRange range) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        MisReplicatedRangeQueueDTO oldR = null;
        try {
            oldR = this.createPersistable(range, session);
            session.deletePersistent(oldR);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        finally {
            session.release(oldR);
        }
    }

    public void remove(List<MisReplicatedRange> ranges) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<MisReplicatedRangeQueueDTO> oldRs = new ArrayList<MisReplicatedRangeQueueDTO>(ranges.size());
        try {
            for (MisReplicatedRange range : ranges) {
                oldRs.add(this.createPersistable(range, session));
            }
            session.deletePersistentAll(oldRs);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        finally {
            session.release(oldRs);
        }
    }

    public List<MisReplicatedRange> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<MisReplicatedRangeQueueDTO> dobj = qb.createQueryDefinition(MisReplicatedRangeQueueDTO.class);
        HopsQuery<MisReplicatedRangeQueueDTO> query = session.createQuery(dobj);
        List<MisReplicatedRangeQueueDTO> dtos = query.getResultList();
        List<MisReplicatedRange> directives = this.convert(dtos);
        session.release(dtos);
        return directives;
    }

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_misreplicated_range_queue");
    }

    private MisReplicatedRangeQueueDTO createPersistable(MisReplicatedRange range, HopsSession session) throws StorageException {
        MisReplicatedRangeQueueDTO dto = session.newInstance(MisReplicatedRangeQueueDTO.class);
        dto.setNnId(range.getNnId());
        dto.setStartIndex(range.getStartIndex());
        return dto;
    }

    private List<MisReplicatedRange> convert(List<MisReplicatedRangeQueueDTO> dtos) {
        ArrayList<MisReplicatedRange> result = new ArrayList<MisReplicatedRange>(dtos.size());
        for (MisReplicatedRangeQueueDTO dto : dtos) {
            result.add(new MisReplicatedRange(dto.getNnId(), dto.getStartIndex()));
        }
        return result;
    }

    @PersistenceCapable(table="hdfs_misreplicated_range_queue")
    public static interface MisReplicatedRangeQueueDTO {
        @PrimaryKey
        @Column(name="nn_id")
        public long getNnId();

        public void setNnId(long var1);

        @Column(name="start_index")
        public long getStartIndex();

        public void setStartIndex(long var1);
    }
}

