/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.RepairJobsDataAccess;
import io.hops.metadata.hdfs.entity.RepairJob;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepairJobsClusterj
implements TablesDef.RepairJobsTableDef,
RepairJobsDataAccess<RepairJob> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RepairJob repairJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        RepairJobDto dto = null;
        try {
            dto = this.createPersistable(repairJob);
            session.makePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RepairJob encodingJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        RepairJobDto dto = null;
        try {
            dto = this.createPersistable(encodingJob);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    public Collection<RepairJob> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<RepairJobDto> dobj = qb.createQueryDefinition(RepairJobDto.class);
        HopsQuery<RepairJobDto> query = session.createQuery(dobj);
        return this.convertAndRelease(session, query.getResultList());
    }

    private RepairJobDto createPersistable(RepairJob repairJob) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        RepairJobDto dto = session.newInstance(RepairJobDto.class);
        dto.setJtidentifier(repairJob.getJtIdentifier());
        dto.setJobId(repairJob.getJobId());
        dto.setPath(repairJob.getPath());
        dto.setInDir(repairJob.getInDir());
        dto.setOutDir(repairJob.getOutDir());
        return dto;
    }

    private RepairJob convertAndRelease(HopsSession session, RepairJobDto dto) throws StorageException {
        RepairJob job = new RepairJob();
        job.setJtIdentifier(dto.getJtidentifier());
        job.setJobId(dto.getJobId());
        job.setPath(dto.getPath());
        job.setInDir(dto.getInDir());
        job.setOutDir(dto.getOutDir());
        session.release(dto);
        return job;
    }

    private List<RepairJob> convertAndRelease(HopsSession session, List<RepairJobDto> dtos) throws StorageException {
        ArrayList<RepairJob> list = new ArrayList<RepairJob>(dtos.size());
        for (RepairJobDto dto : dtos) {
            list.add(this.convertAndRelease(session, dto));
        }
        return list;
    }

    @PersistenceCapable(table="hdfs_repair_jobs")
    public static interface RepairJobDto {
        @PrimaryKey
        @Column(name="jt_identifier")
        public String getJtidentifier();

        public void setJtidentifier(String var1);

        @PrimaryKey
        @Column(name="job_id")
        public int getJobId();

        public void setJobId(int var1);

        @Column(name="path")
        public String getPath();

        public void setPath(String var1);

        @Column(name="in_dir")
        public String getInDir();

        public void setInDir(String var1);

        @Column(name="out_dir")
        public String getOutDir();

        public void setOutDir(String var1);
    }
}

