/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsPredicateOperand;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LeasePathClusterj
implements TablesDef.LeasePathTableDef,
LeasePathDataAccess<LeasePath> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<LeasePath> removed, Collection<LeasePath> newed, Collection<LeasePath> modified) throws StorageException {
        ArrayList<LeasePathsDTO> changes = new ArrayList<LeasePathsDTO>();
        ArrayList<LeasePathsDTO> deletions = new ArrayList<LeasePathsDTO>();
        HopsSession dbSession = this.connector.obtainSession();
        try {
            LeasePathsDTO lTable;
            for (LeasePath lp : newed) {
                lTable = dbSession.newInstance(LeasePathsDTO.class);
                this.createPersistableLeasePathInstance(lp, lTable);
                changes.add(lTable);
            }
            for (LeasePath lp : modified) {
                lTable = dbSession.newInstance(LeasePathsDTO.class);
                this.createPersistableLeasePathInstance(lp, lTable);
                changes.add(lTable);
            }
            for (LeasePath lp : removed) {
                Object[] key = new Object[]{lp.getHolderId(), lp.getPath()};
                LeasePathsDTO lTable2 = dbSession.newInstance(LeasePathsDTO.class, key);
                deletions.add(lTable2);
            }
            dbSession.deletePersistentAll(deletions);
            dbSession.savePersistentAll(changes);
        }
        finally {
            dbSession.release(deletions);
            dbSession.release(changes);
        }
    }

    public Collection<LeasePath> findByHolderId(int holderId) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<LeasePathsDTO> dobj = qb.createQueryDefinition(LeasePathsDTO.class);
        HopsPredicate pred1 = dobj.get("holderId").equal(dobj.param("param1"));
        dobj.where(pred1);
        HopsQuery<LeasePathsDTO> query = dbSession.createQuery(dobj);
        query.setParameter("param1", holderId);
        List<LeasePathsDTO> dtos = query.getResultList();
        List<LeasePath> lpl = this.createList(dtos);
        dbSession.release(dtos);
        return lpl;
    }

    public LeasePath findByPath(String path) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<LeasePathsDTO> dobj = qb.createQueryDefinition(LeasePathsDTO.class);
        HopsPredicate pred1 = dobj.get("path").equal(dobj.param("param1"));
        dobj.where(pred1);
        HopsQuery<LeasePathsDTO> query = dbSession.createQuery(dobj);
        query.setParameter("param1", path);
        List<LeasePathsDTO> dtos = null;
        try {
            dtos = query.getResultList();
            if (dtos == null || dtos.isEmpty()) {
                LeasePath leasePath = null;
                return leasePath;
            }
            if (dtos.size() == 1) {
                LeasePath lp;
                LeasePath leasePath = lp = this.createLeasePath(dtos.get(0));
                return leasePath;
            }
            throw new StorageException("Found more than one path");
        }
        finally {
            dbSession.release(dtos);
        }
    }

    public Collection<LeasePath> findByPrefix(String prefix) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<LeasePathsDTO> dobj = qb.createQueryDefinition(LeasePathsDTO.class);
        HopsPredicateOperand propertyPredicate = dobj.get("path");
        String param = "prefix";
        HopsPredicateOperand propertyLimit = dobj.param(param);
        HopsPredicate like = propertyPredicate.like(propertyLimit);
        dobj.where(like);
        HopsQuery<LeasePathsDTO> query = dbSession.createQuery(dobj);
        query.setParameter(param, prefix + "%");
        List<LeasePathsDTO> dtos = query.getResultList();
        List<LeasePath> lpl = this.createList(dtos);
        dbSession.release(dtos);
        return lpl;
    }

    public Collection<LeasePath> findAll() throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQuery<LeasePathsDTO> query = dbSession.createQuery(qb.createQueryDefinition(LeasePathsDTO.class));
        List<LeasePathsDTO> dtos = query.getResultList();
        List<LeasePath> lpl = this.createList(dtos);
        dbSession.release(dtos);
        return lpl;
    }

    public void removeAll() throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        dbSession.deletePersistentAll(LeasePathsDTO.class);
    }

    private List<LeasePath> createList(Collection<LeasePathsDTO> dtos) {
        ArrayList<LeasePath> list = new ArrayList<LeasePath>();
        for (LeasePathsDTO leasePathsDTO : dtos) {
            list.add(this.createLeasePath(leasePathsDTO));
        }
        return list;
    }

    private LeasePath createLeasePath(LeasePathsDTO leasePathTable) {
        return new LeasePath(leasePathTable.getPath(), leasePathTable.getHolderId(), leasePathTable.getLastBlockId(), leasePathTable.getPenultimateBlockId());
    }

    private void createPersistableLeasePathInstance(LeasePath lp, LeasePathsDTO lTable) {
        lTable.setHolderId(lp.getHolderId());
        lTable.setPath(lp.getPath());
        lTable.setLastBlockId(lp.getLastBlockId());
        lTable.setPenultimateBlockId(lp.getPenultimateBlockId());
    }

    @PersistenceCapable(table="hdfs_lease_paths")
    @PartitionKey(column="holder_id")
    public static interface LeasePathsDTO {
        @PrimaryKey
        @Column(name="holder_id")
        public int getHolderId();

        public void setHolderId(int var1);

        @PrimaryKey
        @Column(name="path")
        @Index(name="path_idx")
        public String getPath();

        public void setPath(String var1);

        @Column(name="last_block_id")
        public long getLastBlockId();

        public void setLastBlockId(long var1);

        @Column(name="penultimate_block_id")
        public long getPenultimateBlockId();

        public void setPenultimateBlockId(long var1);
    }
}

