/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.LockMode;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.DBSession;
import io.hops.metadata.ndb.wrapper.ClusterJCaching;
import io.hops.metadata.ndb.wrapper.HopsExceptionHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.ndb.wrapper.HopsSessionFactory;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBSessionProvider
implements Runnable {
    static final Log LOG = LogFactory.getLog(DBSessionProvider.class);
    static HopsSessionFactory sessionFactory;
    private ConcurrentLinkedQueue<DBSession> sessionPool = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DBSession> toGC = new ConcurrentLinkedQueue();
    private final int MAX_REUSE_COUNT;
    private Properties conf;
    private final Random rand;
    private AtomicInteger sessionsCreated = new AtomicInteger(0);
    private long[] rollingAvg;
    private AtomicInteger rollingAvgIndex = new AtomicInteger(-1);
    private boolean automaticRefresh = false;
    private Thread thread;
    private final ClusterJCaching clusterJCaching;
    private UUID currentConnectionID;
    private final int initialPoolSize;
    boolean reconnecting = false;

    public DBSessionProvider(Properties conf) throws StorageException {
        this.conf = conf;
        boolean useClusterjDtoCache = Boolean.parseBoolean((String)conf.get("io.hops.enable.clusterj.dto.cache"));
        boolean useClusterjSessionCache = Boolean.parseBoolean((String)conf.get("io.hops.enable.clusterj.session.cache"));
        this.clusterJCaching = new ClusterJCaching(useClusterjDtoCache, useClusterjSessionCache);
        this.initialPoolSize = Integer.parseInt((String)conf.get("io.hops.session.pool.size"));
        int reuseCount = Integer.parseInt((String)conf.get("io.hops.session.reuse.count"));
        if (reuseCount <= 0) {
            System.err.println("Invalid value for session reuse count");
            System.exit(-1);
        }
        this.MAX_REUSE_COUNT = reuseCount;
        this.rand = new Random(System.currentTimeMillis());
        this.rollingAvg = new long[this.initialPoolSize];
        this.start(this.initialPoolSize);
    }

    private void start(int initialPoolSize) throws StorageException {
        LOG.info((Object)("Database connect string: " + this.conf.get("com.mysql.clusterj.connectstring")));
        LOG.info((Object)("Database name: " + this.conf.get("com.mysql.clusterj.database")));
        LOG.info((Object)("Max Transactions: " + this.conf.get("com.mysql.clusterj.max.transactions")));
        LOG.info((Object)("Reconnect Timeout: " + this.conf.get("com.mysql.clusterj.connection.reconnect.timeout")));
        LOG.info((Object)("Using ClusterJ Session Cache: " + this.clusterJCaching.useClusterjSessionCache()));
        LOG.info((Object)("Using ClusterJ DTO Cache: " + this.clusterJCaching.useClusterjDtoCache()));
        try {
            sessionFactory = new HopsSessionFactory(ClusterJHelper.getSessionFactory((Map)this.conf), this.clusterJCaching);
        }
        catch (ClusterJException ex) {
            throw HopsExceptionHelper.wrap(ex);
        }
        this.createNewSessions();
        this.thread = new Thread((Runnable)this, "Session Pool Refresh Daemon");
        this.thread.setDaemon(true);
        this.automaticRefresh = true;
        this.thread.start();
    }

    private DBSession initSession() throws StorageException {
        Long startTime = System.currentTimeMillis();
        HopsSession session = sessionFactory.getSession();
        Long sessionCreationTime = System.currentTimeMillis() - startTime;
        this.rollingAvg[this.rollingAvgIndex.incrementAndGet() % this.rollingAvg.length] = sessionCreationTime;
        int reuseCount = this.rand.nextInt(this.MAX_REUSE_COUNT) + 1;
        DBSession dbSession = new DBSession(session, reuseCount, this.currentConnectionID);
        this.sessionsCreated.incrementAndGet();
        return dbSession;
    }

    private void closeSession(DBSession dbSession) throws StorageException {
        Long startTime = System.currentTimeMillis();
        dbSession.getSession().close();
        Long sessionCreationTime = System.currentTimeMillis() - startTime;
        this.rollingAvg[this.rollingAvgIndex.incrementAndGet() % this.rollingAvg.length] = sessionCreationTime;
    }

    public void stop() throws StorageException {
        this.automaticRefresh = false;
        while (!this.sessionPool.isEmpty()) {
            DBSession dbsession = (DBSession)this.sessionPool.remove();
            this.closeSession(dbsession);
        }
    }

    public DBSession getSession() throws StorageException {
        try {
            DBSession session = (DBSession)this.sessionPool.remove();
            return session;
        }
        catch (NoSuchElementException e) {
            LOG.warn((Object)"DB session provider cant keep up with the demand for new sessions");
            return this.initSession();
        }
    }

    public void returnSession(DBSession returnedSession, Exception ... exceptions) throws StorageException {
        boolean forceClose = false;
        if (sessionFactory.isOpen()) {
            for (Exception e : exceptions) {
                if (e == null) continue;
                Throwable cause = e.getCause();
                if (cause instanceof ClusterJDatastoreException) {
                    forceClose = true;
                    continue;
                }
                if (cause instanceof ClusterJUserException) {
                    if (!cause.getMessage().contains("No more operations can be performed while this Db is closing")) continue;
                    forceClose = true;
                    continue;
                }
                if (returnedSession.getConnectionID() == this.currentConnectionID) continue;
                forceClose = true;
            }
        }
        returnedSession.setSessionUseCount(returnedSession.getSessionUseCount() + 1);
        if (sessionFactory.isOpen() && (returnedSession.getSessionUseCount() >= returnedSession.getMaxReuseCount() || forceClose)) {
            this.toGC.add(returnedSession);
        } else {
            returnedSession.getSession().setLockMode(LockMode.READ_COMMITTED);
            this.sessionPool.add(returnedSession);
        }
    }

    public double getSessionCreationRollingAvg() {
        double avg = 0.0;
        for (long aRollingAvg : this.rollingAvg) {
            avg += (double)aRollingAvg;
        }
        return avg /= (double)this.rollingAvg.length;
    }

    public int getTotalSessionsCreated() {
        return this.sessionsCreated.get();
    }

    public int getAvailableSessions() {
        return this.sessionPool.size();
    }

    @Override
    public void run() {
        while (this.automaticRefresh) {
            try {
                if (!sessionFactory.isOpen()) {
                    this.reconnecting = true;
                    sessionFactory.reconnect();
                }
                if (sessionFactory.isOpen() && this.reconnecting) {
                    this.reconnecting = false;
                    this.currentConnectionID = UUID.randomUUID();
                    this.renewAllSessions();
                    this.gcSessions(false);
                } else {
                    this.gcSessions(true);
                }
                Thread.sleep(50L);
            }
            catch (NoSuchElementException e) {
                for (int i = 0; i < 100; ++i) {
                    try {
                        this.sessionPool.add(this.initSession());
                        continue;
                    }
                    catch (StorageException e1) {
                        LOG.error((Object)e1);
                    }
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex);
                Thread.currentThread().interrupt();
            }
            catch (StorageException e) {
                LOG.error((Object)e);
            }
        }
    }

    public void renewAllSessions() throws StorageException {
        while (!this.sessionPool.isEmpty()) {
            DBSession session = this.sessionPool.poll();
            if (session == null) continue;
            this.closeSession(session);
        }
        this.createNewSessions();
    }

    public void gcSessions(boolean createNewSessions) throws StorageException {
        int toGCSize = this.toGC.size();
        if (toGCSize > 0) {
            int i;
            LOG.debug((Object)("Renewing a session(s) " + toGCSize));
            for (i = 0; i < toGCSize; ++i) {
                DBSession session = (DBSession)this.toGC.remove();
                this.closeSession(session);
            }
            if (createNewSessions) {
                for (i = 0; i < toGCSize; ++i) {
                    this.sessionPool.add(this.initSession());
                }
            }
        }
    }

    public void createNewSessions() throws StorageException {
        for (int i = 0; i < this.initialPoolSize; ++i) {
            this.sessionPool.add(this.initSession());
        }
    }

    public void clearCache() throws StorageException {
        for (DBSession session : this.sessionPool) {
            session.getSession().dropInstanceCache();
        }
    }
}

