/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.ActiveBlockReportsDataAccess;
import io.hops.metadata.hdfs.entity.ActiveBlockReport;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ActiveBlockReportsClusterj
implements TablesDef.ActiveBlockReports,
ActiveBlockReportsDataAccess<ActiveBlockReport> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public int countActiveRports() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_active_block_reports");
    }

    public void addActiveReport(ActiveBlockReport abr) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ActiveBlockReportDTO dto = this.convertToDto(session, abr);
        session.savePersistent(dto);
        session.release(dto);
    }

    public void removeActiveReport(ActiveBlockReport abr) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ActiveBlockReportDTO dto = this.convertToDto(session, abr);
        session.deletePersistent(dto);
        session.release(dto);
    }

    private ActiveBlockReportDTO convertToDto(HopsSession session, ActiveBlockReport abr) throws StorageException {
        ActiveBlockReportDTO dto = session.newInstance(ActiveBlockReportDTO.class);
        dto.setDnAddress(abr.getDnAddress());
        dto.setNnId(abr.getNnId());
        dto.setNnAddress(abr.getNnAddress());
        dto.setStartTime(abr.getStartTime());
        dto.setNumBlocks(abr.getNumBlocks());
        return dto;
    }

    public List<ActiveBlockReport> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<ActiveBlockReportDTO> query = session.createQuery(qb.createQueryDefinition(ActiveBlockReportDTO.class));
        return this.convertAndRelease(session, query.getResultList());
    }

    public ActiveBlockReport getActiveBlockReport(ActiveBlockReport abr) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ActiveBlockReportDTO dto = session.find(ActiveBlockReportDTO.class, abr.getDnAddress());
        ActiveBlockReport result = null;
        if (dto != null) {
            result = this.convertAndRelease(session, dto);
        }
        return result;
    }

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_active_block_reports");
    }

    public void removeAll() throws StorageException {
        try {
            while (this.countAll() != 0) {
                MysqlServerConnector.truncateTable("hdfs_active_block_reports", 10000);
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
    }

    private List<ActiveBlockReport> convertAndRelease(HopsSession session, Collection<ActiveBlockReportDTO> dtos) throws StorageException {
        ArrayList<ActiveBlockReport> list = new ArrayList<ActiveBlockReport>();
        for (ActiveBlockReportDTO dto : dtos) {
            list.add(this.convertAndRelease(session, dto));
        }
        return list;
    }

    private ActiveBlockReport convertAndRelease(HopsSession session, ActiveBlockReportDTO abrDto) throws StorageException {
        ActiveBlockReport abr = new ActiveBlockReport(abrDto.getDnAddress(), abrDto.getNnId(), abrDto.getNnAddress(), abrDto.getStartTime(), abrDto.getNumBlocks());
        session.release(abrDto);
        return abr;
    }

    @PersistenceCapable(table="hdfs_active_block_reports")
    public static interface ActiveBlockReportDTO {
        @PrimaryKey
        @Column(name="dn_address")
        public String getDnAddress();

        public void setDnAddress(String var1);

        @Column(name="nn_id")
        public long getNnId();

        public void setNnId(long var1);

        @Column(name="nn_address")
        public String getNnAddress();

        public void setNnAddress(String var1);

        @Column(name="start_time")
        public long getStartTime();

        public void setStartTime(long var1);

        @Column(name="num_blocks")
        public long getNumBlocks();

        public void setNumBlocks(long var1);
    }
}

