/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.Index;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.CorruptReplicaDataAccess;
import io.hops.metadata.hdfs.entity.CorruptReplica;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CorruptReplicaClusterj
implements TablesDef.CorruptReplicaTableDef,
CorruptReplicaDataAccess<CorruptReplica> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_corrupt_replicas");
    }

    public int countAllUniqueBlk() throws StorageException {
        return MySQLQueryHelper.countAllUnique("hdfs_corrupt_replicas", "block_id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<CorruptReplica> removed, Collection<CorruptReplica> newed) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        ArrayList<CorruptReplicaDTO> changes = new ArrayList<CorruptReplicaDTO>();
        ArrayList<CorruptReplicaDTO> deletions = new ArrayList<CorruptReplicaDTO>();
        try {
            CorruptReplicaDTO newInstance;
            for (CorruptReplica corruptReplica : removed) {
                newInstance = dbSession.newInstance(CorruptReplicaDTO.class);
                this.createPersistable(corruptReplica, newInstance);
                deletions.add(newInstance);
            }
            for (CorruptReplica corruptReplica : newed) {
                newInstance = dbSession.newInstance(CorruptReplicaDTO.class);
                this.createPersistable(corruptReplica, newInstance);
                changes.add(newInstance);
            }
            dbSession.deletePersistentAll(deletions);
            dbSession.savePersistentAll(changes);
        }
        finally {
            dbSession.release(deletions);
            dbSession.release(changes);
        }
    }

    public CorruptReplica findByPk(long blockId, int sid, int inodeId) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        Object[] keys = new Object[]{inodeId, blockId, sid};
        CorruptReplicaDTO corruptReplicaTable = dbSession.find(CorruptReplicaDTO.class, keys);
        if (corruptReplicaTable != null) {
            CorruptReplica cr = this.createReplica(corruptReplicaTable);
            dbSession.release(corruptReplicaTable);
            return cr;
        }
        return null;
    }

    public List<CorruptReplica> findAll() throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<CorruptReplicaDTO> dobj = qb.createQueryDefinition(CorruptReplicaDTO.class);
        HopsQuery<CorruptReplicaDTO> query = dbSession.createQuery(dobj);
        query.setOrdering(Query.Ordering.ASCENDING, "timestamp");
        List<CorruptReplicaDTO> ibts = query.getResultList();
        List<CorruptReplica> lcr = this.createCorruptReplicaList(ibts);
        dbSession.release(ibts);
        return lcr;
    }

    public List<CorruptReplica> findByBlockId(long blockId, long inodeId) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<CorruptReplicaDTO> dobj = qb.createQueryDefinition(CorruptReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockId"));
        HopsPredicate pred2 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<CorruptReplicaDTO> query = dbSession.createQuery(dobj);
        query.setParameter("blockId", blockId);
        query.setParameter("iNodeIdParam", inodeId);
        List<CorruptReplicaDTO> creplicas = query.getResultList();
        List<CorruptReplica> lcr = this.createCorruptReplicaList(creplicas);
        dbSession.release(creplicas);
        return lcr;
    }

    public List<CorruptReplica> findByINodeId(long inodeId) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<CorruptReplicaDTO> dobj = qb.createQueryDefinition(CorruptReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<CorruptReplicaDTO> query = dbSession.createQuery(dobj);
        query.setParameter("iNodeIdParam", inodeId);
        List<CorruptReplicaDTO> dtos = query.getResultList();
        List<CorruptReplica> lcr = this.createCorruptReplicaList(dtos);
        dbSession.release(dtos);
        return lcr;
    }

    public List<CorruptReplica> findByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        HopsQueryBuilder qb = dbSession.getQueryBuilder();
        HopsQueryDomainType<CorruptReplicaDTO> dobj = qb.createQueryDefinition(CorruptReplicaDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").in(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<CorruptReplicaDTO> query = dbSession.createQuery(dobj);
        query.setParameter("iNodeIdParam", Longs.asList((long[])inodeIds));
        List<CorruptReplicaDTO> dtos = query.getResultList();
        List<CorruptReplica> crl = this.createCorruptReplicaList(dtos);
        dbSession.release(dtos);
        return crl;
    }

    private CorruptReplica createReplica(CorruptReplicaDTO corruptReplicaTable) {
        return new CorruptReplica(corruptReplicaTable.getStorageId(), corruptReplicaTable.getBlockId(), corruptReplicaTable.getINodeId(), corruptReplicaTable.getReason());
    }

    private List<CorruptReplica> createCorruptReplicaList(List<CorruptReplicaDTO> persistables) {
        ArrayList<CorruptReplica> replicas = new ArrayList<CorruptReplica>();
        for (CorruptReplicaDTO bit : persistables) {
            replicas.add(this.createReplica(bit));
        }
        return replicas;
    }

    private void createPersistable(CorruptReplica corruptReplica, CorruptReplicaDTO corruptReplicaTable) {
        corruptReplicaTable.setBlockId(corruptReplica.getBlockId());
        corruptReplicaTable.setStorageId(corruptReplica.getStorageId());
        corruptReplicaTable.setINodeId(corruptReplica.getInodeId());
        corruptReplicaTable.setTimestamp(System.currentTimeMillis());
        corruptReplicaTable.setReason(corruptReplica.getReason());
    }

    @PersistenceCapable(table="hdfs_corrupt_replicas")
    @PartitionKey(column="inode_id")
    @Index(name="timestamp")
    public static interface CorruptReplicaDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="timestamp")
        public long getTimestamp();

        public void setTimestamp(long var1);

        @Column(name="reason")
        public String getReason();

        public void setReason(String var1);
    }
}

