/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.entity.User;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.List;

public class UserClusterj
implements TablesDef.UsersTableDef,
UserDataAccess<User> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public User getUser(int userId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        UserDTO dto = session.find(UserDTO.class, userId);
        User user = null;
        if (dto != null) {
            user = new User(dto.getId(), dto.getName());
            session.release(dto);
        }
        return user;
    }

    public User getUser(String userName) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        return this.getUser(session, userName);
    }

    public User addUser(String userName) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        User user = this.getUser(session, userName);
        if (user == null) {
            this.addUser(session, userName);
            session.flush();
            user = this.getUser(session, userName);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(int userId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        UserDTO dto = null;
        try {
            dto = session.newInstance(UserDTO.class, userId);
            session.deletePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUser(HopsSession session, String userName) throws StorageException {
        UserDTO dto = null;
        try {
            dto = session.newInstance(UserDTO.class);
            dto.setName(userName);
            session.makePersistent(dto);
        }
        finally {
            session.release(dto);
        }
    }

    private User getUser(HopsSession session, String userName) throws StorageException {
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<UserDTO> dobj = qb.createQueryDefinition(UserDTO.class);
        dobj.where(dobj.get("name").equal(dobj.param("param")));
        HopsQuery<UserDTO> query = session.createQuery(dobj);
        query.setParameter("param", userName);
        List<UserDTO> results = query.getResultList();
        User user = null;
        if (results.size() == 1) {
            user = new User(results.get(0).getId(), results.get(0).getName());
        }
        session.release(results);
        return user;
    }

    @PersistenceCapable(table="hdfs_users")
    public static interface UserDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @Column(name="name")
        public String getName();

        public void setName(String var1);
    }
}

