/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.mysqlserver;

import io.hops.exception.StorageException;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountHelper {
    static final Log LOG = LogFactory.getLog(CountHelper.class);
    public static final String COUNT_QUERY = "select count(*) from %s";
    public static final String COUNT_QUERY_UNIQUE = "select count(distinct %s) from %s";
    public static final String COUNT_WHERE = "select count(*) from %s where %s";
    private static MysqlServerConnector connector = MysqlServerConnector.getInstance();

    public static int countWhere(String tableName, String condition) throws StorageException {
        String query = String.format(COUNT_WHERE, tableName, condition);
        return CountHelper.count(query);
    }

    public static int countAll(String tableName) throws StorageException {
        String query = String.format(COUNT_QUERY, tableName);
        return CountHelper.count(query);
    }

    public static int countAllUnique(String tableName, String columnName) throws StorageException {
        String query = String.format(COUNT_QUERY_UNIQUE, columnName, tableName);
        return CountHelper.count(query);
    }

    private static int count(String query) throws StorageException {
        PreparedStatement s = null;
        ResultSet result = null;
        try {
            Connection conn = connector.obtainSession();
            s = conn.prepareStatement(query);
            result = s.executeQuery();
            if (result.next()) {
                int n = result.getInt(1);
                return n;
            }
            try {
                throw new StorageException(String.format("Count result set is empty. Query: %s", query));
            }
            catch (SQLException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Exception when closing the PrepareStatement", (Throwable)ex);
                }
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Exception when closing the ResultSet", (Throwable)ex);
                }
            }
            connector.closeSession();
        }
    }

    public static int countWithCriterion(String tableName, String criterion) throws StorageException {
        StringBuilder queryBuilder = new StringBuilder(String.format(COUNT_QUERY, tableName)).append(" where ").append(criterion);
        return CountHelper.count(queryBuilder.toString());
    }
}

