/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.InMemoryInodeDataAccess;
import io.hops.metadata.hdfs.entity.FileInodeData;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;

public class InMemoryFileInodeClusterj
implements TablesDef.FileInodeInMemoryData,
InMemoryInodeDataAccess<FileInodeData> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public void add(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.InmemoryFile) {
            throw new IllegalArgumentException("Expecting inmemory file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        FileInodeDataDTO dto = session.newInstance(FileInodeDataDTO.class);
        dto.setInodeId(fileInodeData.getInodeId());
        dto.setData(fileInodeData.getInodeData());
        session.savePersistent(dto);
        session.release(dto);
    }

    public void delete(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.InmemoryFile) {
            throw new IllegalArgumentException("Expecting inmemory file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        session.deletePersistent(FileInodeDataDTO.class, fileInodeData.getInodeId());
    }

    public FileInodeData get(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        FileInodeDataDTO dataDto = session.find(FileInodeDataDTO.class, inodeId);
        if (dataDto != null) {
            byte[] data = new byte[dataDto.getData().length];
            System.arraycopy(dataDto.getData(), 0, data, 0, data.length);
            FileInodeData fileData = new FileInodeData(inodeId, data, data.length, FileInodeData.Type.InmemoryFile);
            session.release(dataDto);
            return fileData;
        }
        return null;
    }

    public int count() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_inmemory_file_inode_data");
    }

    public int getLength() throws StorageException {
        String query = "SELECT character_maximum_length  FROM information_schema.columns  WHERE   table_schema =  Database() AND table_name =\"hdfs_inmemory_file_inode_data\" AND column_name = \"data\"";
        return MySQLQueryHelper.executeIntAggrQuery(query);
    }

    @PersistenceCapable(table="hdfs_inmemory_file_inode_data")
    public static interface FileInodeDataDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="data")
        public byte[] getData();

        public void setData(byte[] var1);
    }
}

