/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class VariableClusterj
implements TablesDef.VariableTableDef,
VariableDataAccess<Variable, Variable.Finder> {
    private final Logger LOG = LogManager.getLogger(VariableClusterj.class);
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public Variable getVariable(Variable.Finder varType) throws StorageException {
        VariableDTO vd = null;
        HopsSession session = this.connector.obtainSession();
        int retryCount = 0;
        do {
            if ((vd = session.find(VariableDTO.class, varType.getId())) != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.LOG.warn((Object)("Unable to read variable id=" + varType.getId() + ". retry count: " + retryCount));
        } while (vd == null && retryCount++ < 10);
        if (vd == null) {
            throw new StorageException("There is no variable entry with id " + varType.getId());
        }
        Variable var = Variable.initVariable((Variable.Finder)varType, (byte[])vd.getValue());
        session.release(vd);
        return var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVariable(Variable var) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        VariableDTO vd = null;
        try {
            vd = this.createVariableDTO(session, var);
            session.savePersistent(vd);
        }
        finally {
            session.release(vd);
        }
    }

    public void prepare(Collection<Variable> newVariables, Collection<Variable> updatedVariables, Collection<Variable> removedVariables) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        this.removeVariables(session, removedVariables);
        this.updateVariables(session, newVariables);
        this.updateVariables(session, updatedVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVariables(HopsSession session, Collection<Variable> vars) throws StorageException {
        if (vars != null) {
            ArrayList<VariableDTO> removed = new ArrayList<VariableDTO>();
            try {
                for (Variable var : vars) {
                    VariableDTO vd = session.newInstance(VariableDTO.class, var.getType().getId());
                    removed.add(vd);
                }
                session.deletePersistentAll(removed);
            }
            finally {
                session.release(removed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVariables(HopsSession session, Collection<Variable> vars) throws StorageException {
        ArrayList<VariableDTO> changes = new ArrayList<VariableDTO>();
        try {
            for (Variable var : vars) {
                changes.add(this.createVariableDTO(session, var));
            }
            session.savePersistentAll(changes);
        }
        finally {
            session.release(changes);
        }
    }

    private VariableDTO createVariableDTO(HopsSession session, Variable var) throws StorageException {
        byte[] varVal = var.getBytes();
        if (varVal.length > MAX_VARIABLE_SIZE) {
            throw new StorageException("wrong variable size" + varVal.length + ", variable size should be less or equal to " + MAX_VARIABLE_SIZE);
        }
        VariableDTO vd = session.newInstance(VariableDTO.class);
        vd.setValue(var.getBytes());
        vd.setId(var.getType().getId());
        return vd;
    }

    @PersistenceCapable(table="hdfs_variables")
    public static interface VariableDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @Column(name="value")
        public byte[] getValue();

        public void setValue(byte[] var1);
    }
}

