/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.rmstatestore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.rmstatestore.DelegationTokenDataAccess;
import io.hops.metadata.yarn.entity.rmstatestore.DelegationToken;
import io.hops.util.CompressionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public class DelegationTokenClusterJ
implements TablesDef.DelegationTokenTableDef,
DelegationTokenDataAccess<DelegationToken> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public void add(DelegationToken hopDelegationToken) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DelegationTokenDTO dto = this.createPersistable(hopDelegationToken, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    public List<DelegationToken> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<DelegationTokenDTO> dobj = qb.createQueryDefinition(DelegationTokenDTO.class);
        HopsQuery<DelegationTokenDTO> query = session.createQuery(dobj);
        List<DelegationTokenDTO> queryResults = query.getResultList();
        List<DelegationToken> result = this.createHopDelegationTokenList(queryResults);
        session.release(queryResults);
        return result;
    }

    public void remove(DelegationToken removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        DelegationTokenDTO dto = session.newInstance(DelegationTokenDTO.class, removed.getSeqnumber());
        session.deletePersistent(dto);
        session.release(dto);
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(DelegationTokenDTO.class);
    }

    private DelegationToken createHopDelegationToken(DelegationTokenDTO delegationTokenDTO) throws StorageException {
        try {
            return new DelegationToken(delegationTokenDTO.getseqnumber(), CompressionUtils.decompress(delegationTokenDTO.getrmdtidentifier()));
        }
        catch (IOException | DataFormatException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private List<DelegationToken> createHopDelegationTokenList(List<DelegationTokenDTO> list) throws StorageException {
        ArrayList<DelegationToken> hopList = new ArrayList<DelegationToken>();
        for (DelegationTokenDTO dto : list) {
            hopList.add(this.createHopDelegationToken(dto));
        }
        return hopList;
    }

    private DelegationTokenDTO createPersistable(DelegationToken hop, HopsSession session) throws StorageException {
        DelegationTokenDTO delegationTokenDTO = session.newInstance(DelegationTokenDTO.class);
        delegationTokenDTO.setseqnumber(hop.getSeqnumber());
        try {
            delegationTokenDTO.setrmdtidentifier(CompressionUtils.compress(hop.getRmdtidentifier()));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        return delegationTokenDTO;
    }

    @PersistenceCapable(table="yarn_delegation_token")
    public static interface DelegationTokenDTO {
        @PrimaryKey
        @Column(name="seq_number")
        public int getseqnumber();

        public void setseqnumber(int var1);

        @Column(name="rmdt_identifier")
        public byte[] getrmdtidentifier();

        public void setrmdtidentifier(byte[] var1);
    }
}

