/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.quota;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.quota.PriceMultiplicatorDataAccess;
import io.hops.metadata.yarn.entity.quota.PriceMultiplicator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PriceMultiplicatorClusterJ
implements TablesDef.PriceMultiplicatorTableDef,
PriceMultiplicatorDataAccess<PriceMultiplicator> {
    private static final Log LOG = LogFactory.getLog(PriceMultiplicatorClusterJ.class);
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public Map<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> getAll() throws StorageException {
        LOG.debug((Object)"HOP :: ClusterJ PriceMultiplicator.getAll - START");
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<PriceMultiplicatorDTO> dobj = qb.createQueryDefinition(PriceMultiplicatorDTO.class);
        HopsQuery<PriceMultiplicatorDTO> query = session.createQuery(dobj);
        List<PriceMultiplicatorDTO> queryResults = query.getResultList();
        LOG.debug((Object)"HOP :: ClusterJ PriceMultiplicator.getAll - STOP");
        Map<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> result = PriceMultiplicatorClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public static Map<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> createMap(List<PriceMultiplicatorDTO> results) {
        HashMap<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> map = new HashMap<PriceMultiplicator.MultiplicatorType, PriceMultiplicator>();
        for (PriceMultiplicatorDTO persistable : results) {
            PriceMultiplicator hop = PriceMultiplicatorClusterJ.createHopPriceMultiplicator(persistable);
            map.put(hop.getId(), hop);
        }
        return map;
    }

    private static PriceMultiplicator createHopPriceMultiplicator(PriceMultiplicatorDTO csDTO) {
        PriceMultiplicator hop = new PriceMultiplicator(PriceMultiplicator.MultiplicatorType.valueOf((String)csDTO.getId()), csDTO.getMultiplicator());
        return hop;
    }

    public void add(PriceMultiplicator yarnRunningPrice) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        PriceMultiplicatorDTO toAdd = this.createPersistable(yarnRunningPrice, session);
        session.savePersistent(toAdd);
        session.release(toAdd);
    }

    private PriceMultiplicatorDTO createPersistable(PriceMultiplicator hopPQ, HopsSession session) throws StorageException {
        PriceMultiplicatorDTO pqDTO = session.newInstance(PriceMultiplicatorDTO.class);
        pqDTO.setId(hopPQ.getId().name());
        pqDTO.setMultiplicator(hopPQ.getValue());
        return pqDTO;
    }

    @PersistenceCapable(table="yarn_price_multiplicator")
    public static interface PriceMultiplicatorDTO {
        @PrimaryKey
        @Column(name="id")
        public String getId();

        public void setId(String var1);

        @Column(name="multiplicator")
        public float getMultiplicator();

        public void setMultiplicator(float var1);
    }
}

