/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.StorageDataAccess;
import io.hops.metadata.hdfs.entity.Storage;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StoragesClusterj
implements TablesDef.StoragesTableDef,
StorageDataAccess<Storage> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public void prepare(Collection<Storage> collection, Collection<Storage> collection1) throws StorageException {
    }

    public void add(Storage s) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        StorageDTO sdto = session.newInstance(StorageDTO.class);
        sdto.setStorageId(s.getStorageID());
        sdto.setHostId(s.getHostID());
        sdto.setStorageType(s.getStorageType());
        sdto.setState(s.getState());
        session.savePersistent(sdto);
        session.release(sdto);
    }

    public Storage findByPk(int storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        StorageDTO sdto = session.find(StorageDTO.class, storageId);
        if (sdto == null) {
            return null;
        }
        return this.convertAndRelease(session, sdto);
    }

    public List<Storage> findByHostUuid(String uuid) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<StorageDTO> dobj = qb.createQueryDefinition(StorageDTO.class);
        HopsPredicate pred1 = dobj.get("hostId").equal(dobj.param("hostId"));
        dobj.where(pred1);
        HopsQuery<StorageDTO> query = session.createQuery(dobj);
        query.setParameter("hostId", uuid);
        return this.convertAndRelease(session, query.getResultList());
    }

    public Collection<Storage> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<StorageDTO> qdt = qb.createQueryDefinition(StorageDTO.class);
        HopsQuery<StorageDTO> q = session.createQuery(qdt);
        return this.convertAndRelease(session, q.getResultList());
    }

    private List<Storage> convertAndRelease(HopsSession session, List<StorageDTO> dtos) throws StorageException {
        ArrayList<Storage> list = new ArrayList<Storage>(dtos.size());
        for (StorageDTO dto : dtos) {
            list.add(this.create(dto));
            session.release(dto);
        }
        return list;
    }

    private Storage convertAndRelease(HopsSession session, StorageDTO sdto) throws StorageException {
        Storage storage = new Storage(sdto.getStorageId(), sdto.getHostId(), sdto.getStorageType(), sdto.getState());
        session.release(sdto);
        return storage;
    }

    private Storage create(StorageDTO dto) {
        Storage storage = new Storage(dto.getStorageId(), dto.getHostId(), dto.getStorageType(), dto.getState());
        return storage;
    }

    @PersistenceCapable(table="hdfs_storages")
    public static interface StorageDTO {
        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="host_id")
        public String getHostId();

        public void setHostId(String var1);

        @Column(name="storage_type")
        public int getStorageType();

        public void setStorageType(int var1);

        @Column(name="state")
        public String getState();

        public void setState(String var1);
    }
}

