/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.wrapper;

import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactory;
import io.hops.metadata.ndb.wrapper.HopsClusterJLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HopsLoggerFactory
implements LoggerFactory {
    static final Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    public HopsLoggerFactory() {
        this.registerLogger("com.mysql.clusterj.core");
        this.registerLogger("com.mysql.clusterj.core.metadata");
        this.registerLogger("com.mysql.clusterj.core.query");
        this.registerLogger("com.mysql.clusterj.core.util");
    }

    public Logger registerLogger(String loggerName) {
        Log log = LogFactory.getLog((String)loggerName);
        HopsClusterJLogger result = new HopsClusterJLogger(log);
        loggerMap.put(loggerName, result);
        return result;
    }

    public Logger getInstance(Class cls) {
        String loggerName = HopsLoggerFactory.getPackageName(cls);
        return this.getInstance(loggerName);
    }

    public synchronized Logger getInstance(String loggerName) {
        Logger result = loggerMap.get(loggerName);
        if (result == null) {
            result = this.registerLogger(loggerName);
        }
        return result;
    }

    private static final String getPackageName(Class<?> cls) {
        String className = cls.getName();
        int index = className.lastIndexOf(46);
        return index != -1 ? className.substring(0, index) : "";
    }
}

