/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.StorageIdMapDataAccess;
import io.hops.metadata.hdfs.entity.StorageId;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StorageIdMapClusterj
implements TablesDef.StorageIdMapTableDef,
StorageIdMapDataAccess<StorageId> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(StorageId s) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        StorageIdDTO sdto = null;
        try {
            sdto = session.newInstance(StorageIdDTO.class);
            sdto.setSId(s.getsId());
            sdto.setStorageId(s.getStorageId());
            session.savePersistent(sdto);
        }
        finally {
            session.release(sdto);
        }
    }

    public StorageId findByPk(String storageId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        StorageIdDTO sdto = session.find(StorageIdDTO.class, storageId);
        if (sdto == null) {
            return null;
        }
        return this.convertAndRelease(session, sdto);
    }

    public Collection<StorageId> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<StorageIdDTO> qdt = qb.createQueryDefinition(StorageIdDTO.class);
        HopsQuery<StorageIdDTO> q = session.createQuery(qdt);
        return this.convertAndRelease(session, q.getResultList());
    }

    private Collection<StorageId> convertAndRelease(HopsSession session, List<StorageIdDTO> dtos) throws StorageException {
        ArrayList<StorageId> hopstorageId = new ArrayList<StorageId>();
        for (StorageIdDTO sdto : dtos) {
            hopstorageId.add(this.convertAndRelease(session, sdto));
        }
        return hopstorageId;
    }

    private StorageId convertAndRelease(HopsSession session, StorageIdDTO sdto) throws StorageException {
        StorageId storageId = new StorageId(sdto.getStorageId(), sdto.getSId());
        session.release(sdto);
        return storageId;
    }

    @PersistenceCapable(table="hdfs_storage_id_map")
    public static interface StorageIdDTO {
        @PrimaryKey
        @Column(name="storage_id")
        public String getStorageId();

        public void setStorageId(String var1);

        @Column(name="sid")
        public int getSId();

        public void setSId(int var1);
    }
}

