/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.rmstatestore;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationStateDataAccess;
import io.hops.metadata.yarn.entity.rmstatestore.ApplicationState;
import io.hops.util.CompressionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public class ApplicationStateClusterJ
implements TablesDef.ApplicationStateTableDef,
ApplicationStateDataAccess<ApplicationState> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public ApplicationState findByApplicationId(String id) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ApplicationStateDTO appStateDTO = session.find(ApplicationStateDTO.class, id);
        ApplicationState result = this.createHopApplicationState(appStateDTO);
        session.release(appStateDTO);
        return result;
    }

    public List<ApplicationState> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ApplicationStateDTO> dobj = qb.createQueryDefinition(ApplicationStateDTO.class);
        HopsQuery<ApplicationStateDTO> query = session.createQuery(dobj);
        List<ApplicationStateDTO> queryResults = query.getResultList();
        List<ApplicationState> result = this.createHopApplicationStateList(queryResults);
        session.release(queryResults);
        return result;
    }

    public void add(ApplicationState toAdd) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ApplicationStateDTO dto = this.createPersistable(toAdd, session);
        session.savePersistent(dto);
        session.flush();
        session.release(dto);
    }

    public void remove(ApplicationState toRemove) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ApplicationStateDTO dto = session.newInstance(ApplicationStateDTO.class, toRemove.getApplicationId());
        session.deletePersistent(dto);
        session.release(dto);
    }

    public void removeAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        session.deletePersistentAll(ApplicationStateDTO.class);
    }

    private ApplicationState createHopApplicationState(ApplicationStateDTO appStateDTO) throws StorageException {
        if (appStateDTO != null) {
            ApplicationState state = null;
            try {
                state = new ApplicationState(appStateDTO.getapplicationid(), CompressionUtils.decompress(appStateDTO.getappstate()), appStateDTO.getappuser(), appStateDTO.getappname(), appStateDTO.getappsmstate());
            }
            catch (IOException | DataFormatException e) {
                throw new StorageException((Throwable)e);
            }
            return state;
        }
        return null;
    }

    private List<ApplicationState> createHopApplicationStateList(List<ApplicationStateDTO> list) throws StorageException {
        ArrayList<ApplicationState> hopList = new ArrayList<ApplicationState>();
        for (ApplicationStateDTO dto : list) {
            hopList.add(this.createHopApplicationState(dto));
        }
        return hopList;
    }

    private ApplicationStateDTO createPersistable(ApplicationState hop, HopsSession session) throws StorageException {
        ApplicationStateDTO appStateDTO = session.newInstance(ApplicationStateDTO.class);
        appStateDTO.setapplicationid(hop.getApplicationid());
        try {
            appStateDTO.setappstate(CompressionUtils.compress(hop.getAppstate()));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        appStateDTO.setappuser(hop.getUser());
        String name = hop.getName();
        if (name != null && name.length() > 200) {
            name = name.substring(0, 200);
        }
        appStateDTO.setappname(name);
        appStateDTO.setappsmstate(hop.getState());
        return appStateDTO;
    }

    @PersistenceCapable(table="yarn_applicationstate")
    public static interface ApplicationStateDTO {
        @PrimaryKey
        @Column(name="applicationid")
        public String getapplicationid();

        public void setapplicationid(String var1);

        @Column(name="appstate")
        public byte[] getappstate();

        public void setappstate(byte[] var1);

        @Column(name="appuser")
        public String getappuser();

        public void setappuser(String var1);

        @Column(name="appname")
        public String getappname();

        public void setappname(String var1);

        @Column(name="appsmstate")
        public String getappsmstate();

        public void setappsmstate(String var1);
    }
}

