/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.FileProvXAttrBufferDataAccess;
import io.hops.metadata.hdfs.entity.FileProvXAttrBufferEntry;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileProvXAttrBufferClusterj
implements TablesDef.FileProvXAttrBufferTableDef,
FileProvXAttrBufferDataAccess<FileProvXAttrBufferEntry> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    private List<FileProvXAttrBufferEntryDto> createPersistable(FileProvXAttrBufferEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<FileProvXAttrBufferEntryDto> dtos = new ArrayList<FileProvXAttrBufferEntryDto>();
        short numParts = logEntry.getNumParts();
        for (short index = 0; index < numParts; index = (short)(index + 1)) {
            FileProvXAttrBufferEntryDto dto = session.newInstance(FileProvXAttrBufferEntryDto.class);
            dto.setINodeId(logEntry.getInodeId());
            dto.setNamespace(logEntry.getNamespace());
            dto.setName(logEntry.getName());
            dto.setINodeLogicalTime(logEntry.getINodeLogicalTime());
            dto.setValue(logEntry.getValue(index));
            dto.setIndex(index);
            dto.setNumParts(numParts);
            dtos.add(dto);
        }
        return dtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FileProvXAttrBufferEntry logEntry) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<FileProvXAttrBufferEntryDto> dtos = null;
        try {
            dtos = this.createPersistable(logEntry);
            session.savePersistentAll(dtos);
        }
        finally {
            session.release(dtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection<FileProvXAttrBufferEntry> logEntries) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<FileProvXAttrBufferEntryDto> added = new ArrayList<FileProvXAttrBufferEntryDto>(logEntries.size());
        try {
            for (FileProvXAttrBufferEntry logEntry : logEntries) {
                added.addAll(this.createPersistable(logEntry));
            }
            session.savePersistentAll(added);
        }
        finally {
            session.release(added);
        }
    }

    @PersistenceCapable(table="hdfs_file_provenance_xattrs_buffer")
    public static interface FileProvXAttrBufferEntryDto {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="namespace")
        public byte getNamespace();

        public void setNamespace(byte var1);

        @PrimaryKey
        @Column(name="name")
        public String getName();

        public void setName(String var1);

        @PrimaryKey
        @Column(name="inode_logical_time")
        public int getINodeLogicalTime();

        public void setINodeLogicalTime(int var1);

        @PrimaryKey
        @Column(name="index")
        public short getIndex();

        public void setIndex(short var1);

        @Column(name="num_parts")
        public short getNumParts();

        public void setNumParts(short var1);

        @Column(name="value")
        public byte[] getValue();

        public void setValue(byte[] var1);
    }
}

