/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.collect.Lists;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.EncryptionZoneDataAccess;
import io.hops.metadata.hdfs.entity.EncryptionZone;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EncryptionZoneClusterJ
implements TablesDef.EncryptionZones,
EncryptionZoneDataAccess<EncryptionZone> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EncryptionZone> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        List<EncryptionZoneDTO> dtos = null;
        try {
            HopsQueryBuilder qb = session.getQueryBuilder();
            HopsQuery<EncryptionZoneDTO> query = session.createQuery(qb.createQueryDefinition(EncryptionZoneDTO.class));
            dtos = query.getResultList();
            List<EncryptionZone> list = this.convert(dtos);
            return list;
        }
        finally {
            session.release(dtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EncryptionZone> getEncryptionZoneByInodeIdBatch(List<Long> inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList dtos = Lists.newArrayListWithExpectedSize((int)inodeIds.size());
        try {
            for (Long inodeId : inodeIds) {
                EncryptionZoneDTO dto = session.newInstance(EncryptionZoneDTO.class, inodeId);
                session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            List<EncryptionZone> list = this.convert(dtos);
            return list;
        }
        finally {
            session.release(dtos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncryptionZone getEncryptionZoneByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        EncryptionZoneDTO dto = null;
        try {
            dto = session.find(EncryptionZoneDTO.class, inodeId);
            EncryptionZone encryptionZone = this.convert(dto);
            return encryptionZone;
        }
        finally {
            session.release(dto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<EncryptionZone> removed, Collection<EncryptionZone> newed, Collection<EncryptionZone> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<EncryptionZoneDTO> changes = new ArrayList<EncryptionZoneDTO>();
        ArrayList<EncryptionZoneDTO> deletions = new ArrayList<EncryptionZoneDTO>();
        try {
            EncryptionZoneDTO persistable;
            for (EncryptionZone encryptionZone : removed) {
                persistable = this.createPersistable(session, encryptionZone);
                deletions.add(persistable);
            }
            for (EncryptionZone encryptionZone : newed) {
                persistable = this.createPersistable(session, encryptionZone);
                changes.add(persistable);
            }
            for (EncryptionZone encryptionZone : modified) {
                persistable = this.createPersistable(session, encryptionZone);
                changes.add(persistable);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    private EncryptionZoneDTO createPersistable(HopsSession session, EncryptionZone encryptionZone) throws StorageException {
        EncryptionZoneDTO dto = session.newInstance(EncryptionZoneDTO.class);
        dto.setINodeId(encryptionZone.getInodeId());
        dto.setZoneInfo(encryptionZone.getZoneInfo());
        return dto;
    }

    private List<EncryptionZone> convert(List<EncryptionZoneDTO> dtos) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)dtos.size());
        for (EncryptionZoneDTO dto : dtos) {
            results.add(this.convert(dto));
        }
        return results;
    }

    private EncryptionZone convert(EncryptionZoneDTO dto) {
        return new EncryptionZone(dto.getINodeId(), dto.getZoneInfo());
    }

    @PersistenceCapable(table="hdfs_encryption_zone")
    public static interface EncryptionZoneDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @Column(name="zone_info")
        public byte[] getZoneInfo();

        public void setZoneInfo(byte[] var1);
    }
}

