/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.yarn.quota;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import io.hops.metadata.yarn.TablesDef;
import io.hops.metadata.yarn.dal.quota.ProjectQuotaDataAccess;
import io.hops.metadata.yarn.entity.quota.ProjectQuota;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProjectQuotaClusterJ
implements TablesDef.ProjectQuotaTableDef,
ProjectQuotaDataAccess<ProjectQuota> {
    private final ClusterjConnector connector = ClusterjConnector.getInstance();

    public ProjectQuota get(String projectName) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ProjectQuotaDTO dto = session.find(ProjectQuotaDTO.class, projectName);
        ProjectQuota result = null;
        if (dto != null) {
            result = ProjectQuotaClusterJ.createProjectQuota(dto);
        }
        session.release(dto);
        return result;
    }

    public void add(ProjectQuota projectQuota) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ProjectQuotaDTO dto = this.createPersistable(projectQuota, session);
        session.savePersistent(dto);
        session.release(dto);
    }

    public Map<String, ProjectQuota> getAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ProjectQuotaDTO> dobj = qb.createQueryDefinition(ProjectQuotaDTO.class);
        HopsQuery<ProjectQuotaDTO> query = session.createQuery(dobj);
        List<ProjectQuotaDTO> queryResults = query.getResultList();
        Map<String, ProjectQuota> result = ProjectQuotaClusterJ.createMap(queryResults);
        session.release(queryResults);
        return result;
    }

    public static Map<String, ProjectQuota> createMap(List<ProjectQuotaDTO> results) {
        HashMap<String, ProjectQuota> map = new HashMap<String, ProjectQuota>();
        for (ProjectQuotaDTO persistable : results) {
            ProjectQuota hop = ProjectQuotaClusterJ.createProjectQuota(persistable);
            map.put(hop.getProjectid(), hop);
        }
        return map;
    }

    private static ProjectQuota createProjectQuota(ProjectQuotaDTO csDTO) {
        ProjectQuota hop = new ProjectQuota(csDTO.getProjectName(), csDTO.getRemainingQuota(), csDTO.getTotalUsedQuota());
        return hop;
    }

    public void addAll(Collection<ProjectQuota> projectsQuota) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ProjectQuotaDTO> toAdd = new ArrayList<ProjectQuotaDTO>();
        for (ProjectQuota projectQuota : projectsQuota) {
            toAdd.add(this.createPersistable(projectQuota, session));
        }
        session.savePersistentAll(toAdd);
        session.release(toAdd);
    }

    private ProjectQuotaDTO createPersistable(ProjectQuota hopPQ, HopsSession session) throws StorageException {
        ProjectQuotaDTO pqDTO = session.newInstance(ProjectQuotaDTO.class);
        pqDTO.setProjectName(hopPQ.getProjectid());
        pqDTO.setRemainingQuota(hopPQ.getRemainingQuota());
        pqDTO.setTotalUsedQuota(hopPQ.getTotalUsedQuota());
        return pqDTO;
    }

    @PersistenceCapable(table="yarn_projects_quota")
    public static interface ProjectQuotaDTO {
        @PrimaryKey
        @Column(name="projectname")
        public String getProjectName();

        public void setProjectName(String var1);

        @Column(name="quota_remaining")
        public float getRemainingQuota();

        public void setRemainingQuota(float var1);

        @Column(name="total")
        public float getTotalUsedQuota();

        public void setTotalUsedQuota(float var1);
    }
}

