/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.CachePoolDataAccess;
import io.hops.metadata.hdfs.entity.CachePool;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CachePoolClusterJ
implements TablesDef.CachePoolTableDef,
CachePoolDataAccess<CachePool> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    public CachePool find(String key) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        CachePoolDTO result = session.find(CachePoolDTO.class, key);
        if (result != null) {
            CachePool retryCacheEntry = this.convert(result);
            session.release(result);
            return retryCacheEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CachePool> findAboveName(String name) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachePoolDTO> dobj = qb.createQueryDefinition(CachePoolDTO.class);
        HopsPredicate pred1 = dobj.get("poolName").greaterThan(dobj.param("poolName"));
        dobj.where(pred1);
        HopsQuery<CachePoolDTO> query = session.createQuery(dobj);
        query.setParameter("poolName", name);
        List<CachePoolDTO> results = null;
        try {
            results = query.getResultList();
            if (results == null) {
                Collection<CachePool> collection = null;
                return collection;
            }
            Collection<CachePool> collection = this.convert(results);
            return collection;
        }
        finally {
            session.release(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CachePool> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<CachePoolDTO> dobj = qb.createQueryDefinition(CachePoolDTO.class);
        HopsQuery<CachePoolDTO> query = session.createQuery(dobj);
        List<CachePoolDTO> results = null;
        try {
            results = query.getResultList();
            if (results == null) {
                Collection<CachePool> collection = null;
                return collection;
            }
            Collection<CachePool> collection = this.convert(results);
            return collection;
        }
        finally {
            session.release(results);
        }
    }

    public void prepare(Collection<CachePool> removed, Collection<CachePool> modified) throws StorageException {
        CachePoolDTO newInstance;
        ArrayList<CachePoolDTO> changes = new ArrayList<CachePoolDTO>();
        ArrayList<CachePoolDTO> deletions = new ArrayList<CachePoolDTO>();
        HopsSession session = this.connector.obtainSession();
        for (CachePool cachePool : removed) {
            newInstance = session.newInstance(CachePoolDTO.class);
            this.createPersistable(cachePool, newInstance);
            deletions.add(newInstance);
        }
        for (CachePool cachePool : modified) {
            newInstance = session.newInstance(CachePoolDTO.class);
            this.createPersistable(cachePool, newInstance);
            changes.add(newInstance);
        }
        session.deletePersistentAll(deletions);
        session.savePersistentAll(changes);
        session.release(deletions);
        session.release(changes);
    }

    private Collection<CachePool> convert(List<CachePoolDTO> dtos) {
        ArrayList<CachePool> result = new ArrayList<CachePool>(dtos.size());
        for (CachePoolDTO dto : dtos) {
            result.add(this.convert(dto));
        }
        return result;
    }

    private CachePool convert(CachePoolDTO result) {
        return new CachePool(result.getPoolName(), result.getOwnerName(), result.getGroupName(), result.getMode(), result.getLimit(), result.getMaxRelativeExpiryMs(), result.getBytesNeeded(), result.getBytesCached(), result.getFilesNeeded(), result.getFilesCached());
    }

    private void createPersistable(CachePool cachePool, CachePoolDTO newInstance) {
        newInstance.setPoolName(cachePool.getPoolName());
        newInstance.setBytesCached(cachePool.getBytesCached());
        newInstance.setBytesNeeded(cachePool.getBytesNeeded());
        newInstance.setFilesCached(cachePool.getFilesCached());
        newInstance.setFilesNeeded(cachePool.getFilesNeeded());
        newInstance.setGroupName(cachePool.getGroupName());
        newInstance.setLimit(cachePool.getLimit());
        newInstance.setMaxRelativeExpiryMs(cachePool.getMaxRelativeExpiryMs());
        newInstance.setMode(cachePool.getMode());
        newInstance.setOwnerName(cachePool.getOwnerName());
    }

    @PersistenceCapable(table="hdfs_cache_pool")
    public static interface CachePoolDTO {
        @PrimaryKey
        @Column(name="pool_name")
        public String getPoolName();

        public void setPoolName(String var1);

        @Column(name="owner_name")
        public String getOwnerName();

        public void setOwnerName(String var1);

        @Column(name="group_name")
        public String getGroupName();

        public void setGroupName(String var1);

        @Column(name="mode")
        public short getMode();

        public void setMode(short var1);

        @Column(name="limit")
        public long getLimit();

        public void setLimit(long var1);

        @Column(name="max_relative_expiry_ms")
        public long getMaxRelativeExpiryMs();

        public void setMaxRelativeExpiryMs(long var1);

        @Column(name="bytes_needed")
        public long getBytesNeeded();

        public void setBytesNeeded(long var1);

        @Column(name="bytes_cached")
        public long getBytesCached();

        public void setBytesCached(long var1);

        @Column(name="files_needed")
        public long getFilesNeeded();

        public void setFilesNeeded(long var1);

        @Column(name="files_cached")
        public long getFilesCached();

        public void setFilesCached(long var1);
    }
}

