/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.google.common.primitives.Longs;
import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PartitionKey;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.ReplicaUnderConstructionDataAccess;
import io.hops.metadata.hdfs.entity.ReplicaUnderConstruction;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.NdbBoolean;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplicaUnderConstructionClusterj
implements TablesDef.ReplicaUnderConstructionTableDef,
ReplicaUnderConstructionDataAccess<ReplicaUnderConstruction> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<ReplicaUnderConstruction> removed, Collection<ReplicaUnderConstruction> newed, Collection<ReplicaUnderConstruction> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<ReplicaUcDTO> changes = new ArrayList<ReplicaUcDTO>();
        ArrayList<ReplicaUcDTO> deletions = new ArrayList<ReplicaUcDTO>();
        try {
            ReplicaUcDTO newInstance;
            for (ReplicaUnderConstruction replica : removed) {
                newInstance = session.newInstance(ReplicaUcDTO.class);
                this.createPersistable(replica, newInstance);
                deletions.add(newInstance);
            }
            for (ReplicaUnderConstruction replica : newed) {
                newInstance = session.newInstance(ReplicaUcDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            for (ReplicaUnderConstruction replica : modified) {
                newInstance = session.newInstance(ReplicaUcDTO.class);
                this.createPersistable(replica, newInstance);
                changes.add(newInstance);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public List<ReplicaUnderConstruction> findReplicaUnderConstructionByBlockId(long blockId, long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaUcDTO> dobj = qb.createQueryDefinition(ReplicaUcDTO.class);
        HopsPredicate pred1 = dobj.get("blockId").equal(dobj.param("blockIdParam"));
        HopsPredicate pred2 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1.and(pred2));
        HopsQuery<ReplicaUcDTO> query = session.createQuery(dobj);
        query.setParameter("blockIdParam", blockId);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<ReplicaUnderConstruction> findReplicaUnderConstructionByINodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaUcDTO> dobj = qb.createQueryDefinition(ReplicaUcDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").equal(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaUcDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", inodeId);
        return this.convertAndRelease(session, query.getResultList());
    }

    public List<ReplicaUnderConstruction> findReplicaUnderConstructionByINodeIds(long[] inodeIds) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<ReplicaUcDTO> dobj = qb.createQueryDefinition(ReplicaUcDTO.class);
        HopsPredicate pred1 = dobj.get("iNodeId").in(dobj.param("iNodeIdParam"));
        dobj.where(pred1);
        HopsQuery<ReplicaUcDTO> query = session.createQuery(dobj);
        query.setParameter("iNodeIdParam", Longs.asList((long[])inodeIds));
        return this.convertAndRelease(session, query.getResultList());
    }

    public int countAll() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_replica_under_constructions");
    }

    public List<ReplicaUnderConstruction> findAll() throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQuery<ReplicaUcDTO> query = session.createQuery(qb.createQueryDefinition(ReplicaUcDTO.class));
        List<ReplicaUcDTO> dtos = query.getResultList();
        List<ReplicaUnderConstruction> list = this.convertAndRelease(session, dtos);
        return list;
    }

    private List<ReplicaUnderConstruction> convertAndRelease(HopsSession session, List<ReplicaUcDTO> replicaUc) throws StorageException {
        ArrayList<ReplicaUnderConstruction> replicas = new ArrayList<ReplicaUnderConstruction>(replicaUc.size());
        for (ReplicaUcDTO t : replicaUc) {
            replicas.add(new ReplicaUnderConstruction(t.getState(), t.getStorageId(), t.getBlockId(), t.getINodeId(), t.getBucketId(), NdbBoolean.convert(t.getChosenAsPrimary()), t.getGenerationStamp()));
            session.release(t);
        }
        return replicas;
    }

    private void createPersistable(ReplicaUnderConstruction replica, ReplicaUcDTO newInstance) {
        newInstance.setBlockId(replica.getBlockId());
        newInstance.setStorageId(replica.getStorageId());
        newInstance.setState(replica.getState());
        newInstance.setINodeId(replica.getInodeId());
        newInstance.setBucketId(replica.getBucketId());
        newInstance.setChosenAsPrimary(NdbBoolean.convert(replica.getChosenAsPrimary()));
        newInstance.setGenerationStamp(replica.getGenerationStamp());
    }

    @PersistenceCapable(table="hdfs_replica_under_constructions")
    @PartitionKey(column="inode_id")
    public static interface ReplicaUcDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getINodeId();

        public void setINodeId(long var1);

        @PrimaryKey
        @Column(name="block_id")
        public long getBlockId();

        public void setBlockId(long var1);

        @PrimaryKey
        @Column(name="storage_id")
        public int getStorageId();

        public void setStorageId(int var1);

        @Column(name="state")
        public int getState();

        public void setState(int var1);

        @Column(name="bucket_id")
        public int getBucketId();

        public void setBucketId(int var1);

        @Column(name="chosen_as_primary")
        public byte getChosenAsPrimary();

        public void setChosenAsPrimary(byte var1);

        @Column(name="generation_stamp")
        public long getGenerationStamp();

        public void setGenerationStamp(long var1);
    }
}

