/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.QuotaUpdateDataAccess;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.HopsSQLExceptionHelper;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.mysqlserver.MysqlServerConnector;
import io.hops.metadata.ndb.wrapper.HopsPredicate;
import io.hops.metadata.ndb.wrapper.HopsQuery;
import io.hops.metadata.ndb.wrapper.HopsQueryBuilder;
import io.hops.metadata.ndb.wrapper.HopsQueryDomainType;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuotaUpdateClusterj
implements TablesDef.QuotaUpdateTableDef,
QuotaUpdateDataAccess<QuotaUpdate> {
    static final Log LOG = LogFactory.getLog(QuotaUpdateClusterj.class);
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    private MysqlServerConnector mysqlConnector = MysqlServerConnector.getInstance();
    private static final String FIND_QUERY = "SELECT * FROM hdfs_quota_update ORDER BY id LIMIT ?";
    private static final String INODE_ID_PARAM = "inodeId";

    public QuotaUpdate findByKey(int id, long inodeId) throws StorageException {
        HopsSession dbSession = this.connector.obtainSession();
        Object[] keys = new Object[]{id, inodeId};
        QuotaUpdateDTO dto = dbSession.find(QuotaUpdateDTO.class, keys);
        if (dto != null) {
            return this.convertAndRelease(dbSession, dto);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<QuotaUpdate> added, Collection<QuotaUpdate> removed) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<QuotaUpdateDTO> changes = new ArrayList<QuotaUpdateDTO>();
        ArrayList<QuotaUpdateDTO> deletions = new ArrayList<QuotaUpdateDTO>();
        try {
            QuotaUpdateDTO persistable;
            if (removed != null) {
                for (QuotaUpdate update : removed) {
                    persistable = this.createPersistable(update, session);
                    deletions.add(persistable);
                }
            }
            if (added != null) {
                for (QuotaUpdate update : added) {
                    persistable = this.createPersistable(update, session);
                    changes.add(persistable);
                }
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(changes);
        }
    }

    public List<QuotaUpdate> findLimited(int limit) throws StorageException {
        ArrayList<QuotaUpdate> resultList;
        Statement s = null;
        ResultSet result = null;
        try {
            Connection conn = this.mysqlConnector.obtainSession();
            s = conn.prepareStatement(FIND_QUERY);
            s.setInt(1, limit);
            result = s.executeQuery();
            resultList = new ArrayList<QuotaUpdate>();
            while (result.next()) {
                int id = result.getInt("id");
                int inodeId = result.getInt("inode_id");
                int namespaceDelta = result.getInt("namespace_delta");
                long diskspaceDelta = result.getLong("storage_space_delta");
                HashMap<QuotaUpdate.StorageType, Long> typeSpaceDelta = new HashMap<QuotaUpdate.StorageType, Long>();
                typeSpaceDelta.put(QuotaUpdate.StorageType.DISK, result.getLong("typespace_delta_disk"));
                typeSpaceDelta.put(QuotaUpdate.StorageType.SSD, result.getLong("typespace_delta_ssd"));
                typeSpaceDelta.put(QuotaUpdate.StorageType.RAID5, result.getLong("typespace_delta_raid5"));
                typeSpaceDelta.put(QuotaUpdate.StorageType.ARCHIVE, result.getLong("typespace_delta_archive"));
                typeSpaceDelta.put(QuotaUpdate.StorageType.DB, result.getLong("typespace_delta_db"));
                typeSpaceDelta.put(QuotaUpdate.StorageType.PROVIDED, result.getLong("typespace_delta_provided"));
                resultList.add(new QuotaUpdate(id, (long)inodeId, (long)namespaceDelta, diskspaceDelta, typeSpaceDelta));
            }
        }
        catch (SQLException ex) {
            throw HopsSQLExceptionHelper.wrap(ex);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Exception when closing the PrepareStatement", (Throwable)ex);
                }
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException ex) {
                    LOG.warn((Object)"Exception when closing the REsultSet", (Throwable)ex);
                }
            }
            this.mysqlConnector.closeSession();
        }
        return resultList;
    }

    private QuotaUpdateDTO createPersistable(QuotaUpdate update, HopsSession session) throws StorageException {
        QuotaUpdateDTO dto = session.newInstance(QuotaUpdateDTO.class);
        dto.setId(update.getId());
        dto.setInodeId(update.getInodeId());
        dto.setNamespaceDelta(update.getNamespaceDelta());
        dto.setStorageSpaceDelta(update.getStorageSpaceDelta());
        dto.setTypeSpaceDeltaDisk((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.DISK));
        dto.setTypeSpaceDeltaSSD((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.SSD));
        dto.setTypeSpaceDeltaRaid5((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.RAID5));
        dto.setTypeSpaceDeltaArchive((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.ARCHIVE));
        dto.setTypeSpaceDeltaDb((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.DB));
        dto.setTypeSpaceDeltaProvided((Long)update.getTypeSpaces().get(QuotaUpdate.StorageType.PROVIDED));
        return dto;
    }

    private List<QuotaUpdate> convertAndRelease(HopsSession session, List<QuotaUpdateDTO> list) throws StorageException {
        ArrayList<QuotaUpdate> result = new ArrayList<QuotaUpdate>();
        for (QuotaUpdateDTO dto : list) {
            result.add(this.convertAndRelease(session, dto));
        }
        return result;
    }

    private QuotaUpdate convertAndRelease(HopsSession session, QuotaUpdateDTO dto) throws StorageException {
        HashMap<QuotaUpdate.StorageType, Long> typeSpaceDelta = new HashMap<QuotaUpdate.StorageType, Long>();
        typeSpaceDelta.put(QuotaUpdate.StorageType.DISK, dto.getTypeSpaceDeltaDisk());
        typeSpaceDelta.put(QuotaUpdate.StorageType.SSD, dto.getTypeSpaceDeltaSSD());
        typeSpaceDelta.put(QuotaUpdate.StorageType.RAID5, dto.getTypeSpaceDeltaRaid5());
        typeSpaceDelta.put(QuotaUpdate.StorageType.ARCHIVE, dto.getTypeSpaceDeltaArchive());
        typeSpaceDelta.put(QuotaUpdate.StorageType.DB, dto.getTypeSpaceDeltaDb());
        typeSpaceDelta.put(QuotaUpdate.StorageType.PROVIDED, dto.getTypeSpaceDeltaProvided());
        QuotaUpdate result = new QuotaUpdate(dto.getId(), dto.getInodeId(), dto.getNamespaceDelta(), dto.getStorageSpaceDelta(), typeSpaceDelta);
        session.release(dto);
        return result;
    }

    public List<QuotaUpdate> findByInodeId(long inodeId) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        HopsQueryBuilder qb = session.getQueryBuilder();
        HopsQueryDomainType<QuotaUpdateDTO> dobj = qb.createQueryDefinition(QuotaUpdateDTO.class);
        HopsPredicate pred1 = dobj.get(INODE_ID_PARAM).equal(dobj.param(INODE_ID_PARAM));
        dobj.where(pred1);
        HopsQuery<QuotaUpdateDTO> query = session.createQuery(dobj);
        query.setParameter(INODE_ID_PARAM, inodeId);
        List<QuotaUpdateDTO> results = query.getResultList();
        return this.convertAndRelease(session, results);
    }

    public int getCount() throws StorageException {
        int count = MySQLQueryHelper.countAll("hdfs_quota_update");
        return count;
    }

    @PersistenceCapable(table="hdfs_quota_update")
    public static interface QuotaUpdateDTO {
        @PrimaryKey
        @Column(name="id")
        public int getId();

        public void setId(int var1);

        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="namespace_delta")
        public long getNamespaceDelta();

        public void setNamespaceDelta(long var1);

        @Column(name="storage_space_delta")
        public long getStorageSpaceDelta();

        public void setStorageSpaceDelta(long var1);

        @Column(name="typespace_delta_disk")
        public long getTypeSpaceDeltaDisk();

        public void setTypeSpaceDeltaDisk(long var1);

        @Column(name="typespace_delta_ssd")
        public long getTypeSpaceDeltaSSD();

        public void setTypeSpaceDeltaSSD(long var1);

        @Column(name="typespace_delta_raid5")
        public long getTypeSpaceDeltaRaid5();

        public void setTypeSpaceDeltaRaid5(long var1);

        @Column(name="typespace_delta_archive")
        public long getTypeSpaceDeltaArchive();

        public void setTypeSpaceDeltaArchive(long var1);

        @Column(name="typespace_delta_db")
        public long getTypeSpaceDeltaDb();

        public void setTypeSpaceDeltaDb(long var1);

        @Column(name="typespace_delta_provided")
        public long getTypeSpaceDeltaProvided();

        public void setTypeSpaceDeltaProvided(long var1);
    }
}

