/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.LargeOnDiskInodeDataAccess;
import io.hops.metadata.hdfs.entity.FileInodeData;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.mysqlserver.MySQLQueryHelper;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LargeOnDiskFileInodeClusterj
implements TablesDef.FileInodeLargeDiskData,
LargeOnDiskInodeDataAccess<FileInodeData> {
    static final Logger LOG = Logger.getLogger(LargeOnDiskFileInodeClusterj.class);
    private ClusterjConnector connector = ClusterjConnector.getInstance();
    final int CHUNK_SIZE = 8000;

    public void add(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.OnDiskFile) {
            throw new IllegalArgumentException("Expecting on disk file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        int rows = (int)Math.ceil((double)fileInodeData.getSize() / 8000.0);
        ArrayList<FileInodeDataDTO> dtos = new ArrayList<FileInodeDataDTO>();
        for (int index = 0; index < rows; ++index) {
            byte[] buffer = new byte[8000];
            int byteWritten = index * 8000;
            int toWrite = fileInodeData.getSize() - byteWritten;
            if (toWrite > 8000) {
                toWrite = 8000;
            }
            System.arraycopy(fileInodeData.getInodeData(), index * 8000, buffer, 0, toWrite);
            FileInodeDataDTO dto = session.newInstance(FileInodeDataDTO.class);
            dto.setInodeId(fileInodeData.getInodeId());
            dto.setIndex(index);
            dto.setData(buffer);
            dtos.add(dto);
        }
        session.savePersistentAll(dtos);
        session.release(dtos);
    }

    public void delete(FileInodeData fileInodeData) throws StorageException {
        if (fileInodeData.getDBFileStorageType() != FileInodeData.Type.OnDiskFile) {
            throw new IllegalArgumentException("Expecting on disk file object. Got: " + fileInodeData.getDBFileStorageType());
        }
        HopsSession session = this.connector.obtainSession();
        int index = 0;
        while ((double)index < Math.ceil((double)fileInodeData.getSize() / 8000.0)) {
            FileInodeDataDTO dto = session.newInstance(FileInodeDataDTO.class);
            dto.setInodeId(fileInodeData.getInodeId());
            dto.setIndex(index);
            session.deletePersistent(dto);
            session.release(dto);
            ++index;
        }
    }

    public FileInodeData get(long inodeId) throws StorageException {
        throw new UnsupportedOperationException("The operation is not yet implemented");
    }

    public FileInodeData get(long inodeId, int size) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        int rows = (int)Math.ceil((double)size / 8000.0);
        FileInodeDataDTO[] dtos = new FileInodeDataDTO[rows];
        for (int index = 0; index < rows; ++index) {
            FileInodeDataDTO dto;
            dtos[index] = dto = session.newInstance(FileInodeDataDTO.class);
            dto.setInodeId(inodeId);
            dto.setIndex(index);
            session.load(dto);
        }
        session.flush();
        byte[] buffer = new byte[size];
        int remaining = size;
        for (int index = 0; index < rows; ++index) {
            int toRead = -1;
            if (remaining >= 8000) {
                toRead = 8000;
                remaining -= 8000;
            } else {
                toRead = remaining;
            }
            byte[] data = dtos[index].getData();
            if (data.length == 0) {
                Object[] pk = new Object[]{dtos[index].getInodeId(), dtos[index].getIndex()};
                FileInodeDataDTO dto = session.find(FileInodeDataDTO.class, pk);
                if (dto.getData().length == 0) {
                    throw new IllegalStateException("Failed to read the small files data from database");
                }
                data = dto.getData();
            }
            System.arraycopy(data, 0, buffer, index * 8000, toRead);
        }
        FileInodeData fileData = new FileInodeData(inodeId, buffer, size, FileInodeData.Type.OnDiskFile);
        session.release(dtos);
        return fileData;
    }

    public int countUniqueFiles() throws StorageException {
        return MySQLQueryHelper.countAllUnique("hdfs_ondisk_large_file_inode_data", "inode_id");
    }

    public int count() throws StorageException {
        return MySQLQueryHelper.countAll("hdfs_ondisk_large_file_inode_data");
    }

    public int getLength() throws StorageException {
        String query = "SELECT character_maximum_length  FROM information_schema.columns  WHERE   table_schema =  Database() AND table_name =\"hdfs_ondisk_large_file_inode_data\" AND column_name = \"data\"";
        return MySQLQueryHelper.executeIntAggrQuery(query);
    }

    @PersistenceCapable(table="hdfs_ondisk_large_file_inode_data")
    public static interface FileInodeDataDTO {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @Column(name="dindex")
        public int getIndex();

        public void setIndex(int var1);

        @Column(name="data")
        public byte[] getData();

        public void setData(byte[] var1);
    }
}

