/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.ndb.dalimpl.hdfs;

import com.mysql.clusterj.annotation.Column;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.annotation.PrimaryKey;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.TablesDef;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.entity.Ace;
import io.hops.metadata.ndb.ClusterjConnector;
import io.hops.metadata.ndb.NdbBoolean;
import io.hops.metadata.ndb.wrapper.HopsSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AceClusterJ
implements TablesDef.AcesTableDef,
AceDataAccess<Ace> {
    private ClusterjConnector connector = ClusterjConnector.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ace> getAcesByPKBatched(long inodeId, int[] ids) throws StorageException {
        List<Ace> aces;
        HopsSession session = this.connector.obtainSession();
        boolean activeConnector = session.currentTransaction().isActive();
        if (!activeConnector) {
            session.currentTransaction().begin();
        }
        ArrayList<AceDto> dtos = new ArrayList<AceDto>();
        try {
            for (int i = 0; i < ids.length; ++i) {
                AceDto dto = session.newInstance(AceDto.class);
                dto.setInodeId(inodeId);
                dto.setIndex(ids[i]);
                dto = session.load(dto);
                dtos.add(dto);
            }
            session.flush();
            aces = this.fromDtos(dtos);
        }
        finally {
            session.release(dtos);
        }
        if (!activeConnector) {
            session.currentTransaction().commit();
        }
        return aces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(Collection<Ace> removed, Collection<Ace> newed, Collection<Ace> modified) throws StorageException {
        HopsSession session = this.connector.obtainSession();
        ArrayList<AceDto> deletions = new ArrayList<AceDto>();
        ArrayList<AceDto> additions = new ArrayList<AceDto>();
        ArrayList<AceDto> changes = new ArrayList<AceDto>();
        try {
            for (Ace ace : removed) {
                Object[] pk = new Object[]{ace.getInodeId(), ace.getIndex()};
                AceDto persistable = session.newInstance(AceDto.class, pk);
                deletions.add(persistable);
            }
            for (Ace ace : newed) {
                AceDto toAdd = this.createPersistable(session, ace);
                additions.add(toAdd);
            }
            for (Ace ace : modified) {
                AceDto persistable = this.createPersistable(session, ace);
                changes.add(persistable);
            }
            session.deletePersistentAll(deletions);
            session.savePersistentAll(additions);
            session.savePersistentAll(changes);
        }
        finally {
            session.release(deletions);
            session.release(additions);
            session.release(changes);
        }
    }

    private List<Ace> fromDtos(List<AceDto> dtos) {
        ArrayList<Ace> toReturn = new ArrayList<Ace>();
        for (AceDto dto : dtos) {
            toReturn.add(this.fromDto(dto));
        }
        return toReturn;
    }

    private Ace fromDto(AceDto dto) {
        long inode = dto.getInodeId();
        int index = dto.getIndex();
        String subject = dto.getSubject();
        boolean isDefault = NdbBoolean.convert(dto.getIsDefault());
        int permission = dto.getPermission();
        Ace.AceType type = Ace.AceType.valueOf((int)dto.getType());
        return new Ace(inode, index, subject, type, isDefault, permission);
    }

    private AceDto createPersistable(HopsSession session, Ace from) throws StorageException {
        AceDto aceDto = session.newInstance(AceDto.class);
        aceDto.setInodeId(from.getInodeId());
        aceDto.setIndex(from.getIndex());
        if (from.getSubject() == null) {
            aceDto.setSubject("");
        } else {
            aceDto.setSubject(from.getSubject());
        }
        aceDto.setIsDefault(NdbBoolean.convert(from.isDefault()));
        aceDto.setPermission(from.getPermission());
        aceDto.setType(from.getType().getValue());
        return aceDto;
    }

    @PersistenceCapable(table="hdfs_aces")
    public static interface AceDto {
        @PrimaryKey
        @Column(name="inode_id")
        public long getInodeId();

        public void setInodeId(long var1);

        @PrimaryKey
        @Column(name="index")
        public int getIndex();

        public void setIndex(int var1);

        @Column(name="subject")
        public String getSubject();

        public void setSubject(String var1);

        @Column(name="type")
        public int getType();

        public void setType(int var1);

        @Column(name="is_default")
        public byte getIsDefault();

        public void setIsDefault(byte var1);

        @Column(name="permission")
        public int getPermission();

        public void setPermission(int var1);
    }
}

