/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.context.ContextInitializer;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.EntityContextStat;
import io.hops.transaction.context.TransactionContext;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EntityManager {
    private static ThreadLocal<TransactionContext> threadContext = new ThreadLocal();
    private static CopyOnWriteArrayList<ContextInitializer> contextInitializers = new CopyOnWriteArrayList();
    private static boolean initialized = false;

    private EntityManager() {
    }

    public static void addContextInitializer(ContextInitializer ci) {
        contextInitializers.add(ci);
        if (!initialized) {
            initialized = true;
            RequestHandler.setStorageConnector(ci.getConnector());
        }
    }

    private static TransactionContext context() {
        TransactionContext context = threadContext.get();
        if (context == null) {
            context = EntityManager.addContext();
        }
        return context;
    }

    public static void begin() throws StorageException {
        EntityManager.context().begin();
    }

    public static void preventStorageCall(boolean val) {
        EntityManager.context().preventStorageCall(val);
    }

    public static void commit(TransactionLocks tlm) throws TransactionContextException, StorageException {
        EntityManager.context().commit(tlm);
        EntityManager.removeContext();
    }

    public static void rollback(TransactionLocks tlm) throws StorageException, TransactionContextException {
        EntityManager.context().rollback();
        EntityManager.removeContext();
    }

    public static <T> void remove(T obj) throws StorageException, TransactionContextException {
        EntityManager.context().remove(obj);
    }

    public static void removeAll(Class type) throws StorageException, TransactionContextException {
        EntityManager.context().removeAll(type);
    }

    public static <T> Collection<T> findList(FinderType<T> finder, Object ... params) throws TransactionContextException, StorageException {
        return EntityManager.context().findList(finder, params);
    }

    public static <T> T find(FinderType<T> finder, Object ... params) throws TransactionContextException, StorageException {
        return EntityManager.context().find(finder, params);
    }

    public static int count(CounterType counter, Object ... params) throws TransactionContextException, StorageException {
        return EntityManager.context().count(counter, params);
    }

    public static <T> void update(T entity) throws TransactionContextException, StorageException {
        EntityManager.context().update(entity);
    }

    public static <T> void add(T entity) throws TransactionContextException, StorageException {
        EntityManager.context().add(entity);
    }

    public static <T> void snapshotMaintenance(TransactionContextMaintenanceCmds cmds, Object ... params) throws TransactionContextException {
        EntityManager.context().snapshotMaintenance(cmds, params);
    }

    public static void writeLock() throws StorageException {
        EntityContext.setLockMode(EntityContext.LockMode.WRITE_LOCK);
        contextInitializers.get(0).getConnector().writeLock();
    }

    public static void readLock() throws StorageException {
        EntityContext.setLockMode(EntityContext.LockMode.READ_LOCK);
        contextInitializers.get(0).getConnector().readLock();
    }

    public static void readCommited() throws StorageException {
        EntityContext.setLockMode(EntityContext.LockMode.READ_COMMITTED);
        contextInitializers.get(0).getConnector().readCommitted();
    }

    public static void setPartitionKey(Class name, Object key) throws StorageException {
        contextInitializers.get(0).getConnector().setPartitionKey(name, key);
    }

    public static Collection<EntityContextStat> collectSnapshotStat() throws TransactionContextException {
        return EntityManager.context().collectSnapshotStat();
    }

    private static TransactionContext addContext() {
        HashMap<Class, EntityContext> storageMap = new HashMap<Class, EntityContext>();
        for (ContextInitializer initializer : contextInitializers) {
            Map<Class, EntityContext> tmp = initializer.createEntityContexts();
            for (Class clzz : tmp.keySet()) {
                storageMap.put(clzz, tmp.get(clzz));
            }
        }
        TransactionContext context = new TransactionContext(contextInitializers.get(0).getConnector(), storageMap);
        threadContext.set(context);
        return context;
    }

    public static void removeContext() {
        threadContext.remove();
    }
}

