/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.FinderType;
import java.util.Collections;
import java.util.Comparator;

public class UnderReplicatedBlock {
    int level;
    long blockId;
    int inodeId;

    public UnderReplicatedBlock(int level, long blockId, int inodeId) {
        this.level = level;
        this.blockId = blockId;
        this.inodeId = inodeId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getInodeId() {
        return this.inodeId;
    }

    public void setBlockId(long blockId) {
        this.blockId = blockId;
    }

    public void setInodeId(int inodeId) {
        this.inodeId = inodeId;
    }

    public String toString() {
        return "UnderReplicatedBlock{level=" + this.level + ", blockId=" + this.blockId + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnderReplicatedBlock other = (UnderReplicatedBlock)obj;
        return this.blockId == other.blockId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (int)(this.blockId ^ this.blockId >>> 32);
        return hash;
    }

    public static enum Order implements Comparator<UnderReplicatedBlock>
    {
        ByLevel{

            @Override
            public int compare(UnderReplicatedBlock o1, UnderReplicatedBlock o2) {
                if (o1.getLevel() < o2.level) {
                    return -1;
                }
                return 1;
            }
        };


        @Override
        public abstract int compare(UnderReplicatedBlock var1, UnderReplicatedBlock var2);

        public Comparator acsending() {
            return this;
        }

        public Comparator descending() {
            return Collections.reverseOrder(this);
        }
    }

    public static enum Finder implements FinderType<UnderReplicatedBlock>
    {
        ByBlockIdAndINodeId,
        ByINodeId,
        ByINodeIds;


        @Override
        public Class getType() {
            return UnderReplicatedBlock.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByBlockIdAndINodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByINodeId: {
                    return FinderType.Annotation.PrunedIndexScan;
                }
                case ByINodeIds: {
                    return FinderType.Annotation.BatchedPrunedIndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }
}

