/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.EncodingPolicy;

public class EncodingStatus {
    private Integer inodeId;
    private boolean inTree;
    private Integer parityInodeId;
    private Status status;
    private ParityStatus parityStatus;
    private EncodingPolicy encodingPolicy;
    private Long statusModificationTime;
    private Long parityStatusModificationTime;
    private String parityFileName;
    private Integer lostBlocks;
    private Integer lostParityBlocks;
    private Boolean revoked;

    public EncodingStatus() {
    }

    public EncodingStatus(Status status) {
        this.status = status;
    }

    public EncodingStatus(Status status, EncodingPolicy encodingPolicy, String parityFileName) {
        this.status = status;
        this.encodingPolicy = encodingPolicy;
        this.parityFileName = parityFileName;
    }

    public EncodingStatus(Integer inodeId, Status status, EncodingPolicy encodingPolicy, Long statusModificationTime) {
        this(inodeId, true, status, encodingPolicy, statusModificationTime);
    }

    public EncodingStatus(Integer inodeId, boolean inTree, Status status, EncodingPolicy encodingPolicy, Long statusModificationTime) {
        this.inodeId = inodeId;
        this.inTree = inTree;
        this.status = status;
        this.encodingPolicy = encodingPolicy;
        this.statusModificationTime = statusModificationTime;
    }

    public EncodingStatus(Integer inodeId, Integer parityInodeId, Status status, ParityStatus parityStatus, EncodingPolicy encodingPolicy, Long statusModificationTime, Long parityStatusModificationTime, String parityFileName, Integer lostBlocks, Integer lostParityBlocks, Boolean revoked) {
        this(inodeId, true, parityInodeId, status, parityStatus, encodingPolicy, statusModificationTime, parityStatusModificationTime, parityFileName, lostBlocks, lostParityBlocks, revoked);
    }

    public EncodingStatus(Integer inodeId, boolean inTree, Integer parityInodeId, Status status, ParityStatus parityStatus, EncodingPolicy encodingPolicy, Long statusModificationTime, Long parityStatusModificationTime, String parityFileName, Integer lostBlocks, Integer lostParityBlocks, Boolean revoked) {
        this.inodeId = inodeId;
        this.inTree = inTree;
        this.parityInodeId = parityInodeId;
        this.status = status;
        this.parityStatus = parityStatus;
        this.encodingPolicy = encodingPolicy;
        this.statusModificationTime = statusModificationTime;
        this.parityStatusModificationTime = parityStatusModificationTime;
        this.parityFileName = parityFileName;
        this.lostBlocks = lostBlocks;
        this.lostParityBlocks = lostParityBlocks;
        this.revoked = revoked;
    }

    public EncodingStatus(EncodingStatus other) {
        this.inodeId = other.inodeId;
        this.inTree = other.inTree;
        this.parityInodeId = other.parityInodeId;
        this.status = other.status;
        this.parityStatus = other.parityStatus;
        this.encodingPolicy = other.encodingPolicy;
        this.statusModificationTime = other.statusModificationTime;
        this.parityStatusModificationTime = other.parityStatusModificationTime;
        this.parityFileName = other.parityFileName;
        this.lostBlocks = other.lostBlocks;
        this.lostParityBlocks = other.lostParityBlocks;
        this.revoked = other.revoked;
    }

    public Integer getInodeId() {
        return this.inodeId;
    }

    public boolean isInTree() {
        return this.inTree;
    }

    public void setInodeId(Integer inodeId) {
        this.setInodeId(inodeId, true);
    }

    public void setInodeId(Integer inodeId, boolean inTree) {
        this.inodeId = inodeId;
        this.inTree = inTree;
    }

    public Integer getParityInodeId() {
        return this.parityInodeId;
    }

    public void setParityInodeId(Integer parityInodeId) {
        this.parityInodeId = parityInodeId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ParityStatus getParityStatus() {
        return this.parityStatus;
    }

    public void setParityStatus(ParityStatus parityStatus) {
        this.parityStatus = parityStatus;
    }

    public EncodingPolicy getEncodingPolicy() {
        return this.encodingPolicy;
    }

    public void setEncodingPolicy(EncodingPolicy encodingPolicy) {
        this.encodingPolicy = encodingPolicy;
    }

    public Long getStatusModificationTime() {
        return this.statusModificationTime;
    }

    public void setStatusModificationTime(Long statusModificationTime) {
        this.statusModificationTime = statusModificationTime;
    }

    public Long getParityStatusModificationTime() {
        return this.parityStatusModificationTime;
    }

    public void setParityStatusModificationTime(Long parityStatusModificationTime) {
        this.parityStatusModificationTime = parityStatusModificationTime;
    }

    public String getParityFileName() {
        return this.parityFileName;
    }

    public void setParityFileName(String parityFileName) {
        this.parityFileName = parityFileName;
    }

    public Integer getLostBlocks() {
        return this.lostBlocks;
    }

    public void setLostBlocks(Integer lostBlocks) {
        this.lostBlocks = lostBlocks;
    }

    public Integer getLostParityBlocks() {
        return this.lostParityBlocks;
    }

    public void setLostParityBlocks(Integer lostParityBlocks) {
        this.lostParityBlocks = lostParityBlocks;
    }

    public Boolean getRevoked() {
        return this.revoked;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
    }

    public boolean isEncoded() {
        switch (this.status) {
            case ENCODED: 
            case REPAIR_REQUESTED: 
            case REPAIR_ACTIVE: 
            case REPAIR_CANCELED: 
            case REPAIR_FAILED: {
                return true;
            }
        }
        return false;
    }

    public boolean isCorrupt() {
        switch (this.status) {
            case REPAIR_REQUESTED: 
            case REPAIR_ACTIVE: 
            case REPAIR_CANCELED: 
            case REPAIR_FAILED: {
                return true;
            }
        }
        return false;
    }

    public boolean isParityRepairActive() {
        switch (this.parityStatus) {
            case REPAIR_ACTIVE: {
                return true;
            }
        }
        return false;
    }

    public boolean isParityCorrupt() {
        switch (this.parityStatus) {
            case REPAIR_ACTIVE: 
            case REPAIR_REQUESTED: 
            case REPAIR_CANCELED: 
            case REPAIR_FAILED: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "EncodingStatus{inodeId=" + this.inodeId + ", parityInodeId=" + this.parityInodeId + ", status=" + (Object)((Object)this.status) + ", parityStatus=" + (Object)((Object)this.parityStatus) + ", encodingPolicy=" + this.encodingPolicy + ", statusModificationTime=" + this.statusModificationTime + ", parityStatusModificationTime=" + this.parityStatusModificationTime + ", parityFileName='" + this.parityFileName + '\'' + ", lostBlocks=" + this.lostBlocks + ", lostParityBlocks=" + this.lostParityBlocks + ", revoked=" + this.revoked + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodingStatus status1 = (EncodingStatus)o;
        if (this.encodingPolicy != null ? !this.encodingPolicy.equals(status1.encodingPolicy) : status1.encodingPolicy != null) {
            return false;
        }
        if (this.inodeId != null ? !this.inodeId.equals(status1.inodeId) : status1.inodeId != null) {
            return false;
        }
        if (this.lostBlocks != null ? !this.lostBlocks.equals(status1.lostBlocks) : status1.lostBlocks != null) {
            return false;
        }
        if (this.lostParityBlocks != null ? !this.lostParityBlocks.equals(status1.lostParityBlocks) : status1.lostParityBlocks != null) {
            return false;
        }
        if (this.parityFileName != null ? !this.parityFileName.equals(status1.parityFileName) : status1.parityFileName != null) {
            return false;
        }
        if (this.parityInodeId != null ? !this.parityInodeId.equals(status1.parityInodeId) : status1.parityInodeId != null) {
            return false;
        }
        if (this.parityStatus != status1.parityStatus) {
            return false;
        }
        if (this.parityStatusModificationTime != null ? !this.parityStatusModificationTime.equals(status1.parityStatusModificationTime) : status1.parityStatusModificationTime != null) {
            return false;
        }
        if (this.revoked != null ? !this.revoked.equals(status1.revoked) : status1.revoked != null) {
            return false;
        }
        if (this.status != status1.status) {
            return false;
        }
        return !(this.statusModificationTime != null ? !this.statusModificationTime.equals(status1.statusModificationTime) : status1.statusModificationTime != null);
    }

    public int hashCode() {
        int result = this.inodeId != null ? this.inodeId.hashCode() : 0;
        result = 31 * result + (this.parityInodeId != null ? this.parityInodeId.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.parityStatus != null ? this.parityStatus.hashCode() : 0);
        result = 31 * result + (this.encodingPolicy != null ? this.encodingPolicy.hashCode() : 0);
        result = 31 * result + (this.statusModificationTime != null ? this.statusModificationTime.hashCode() : 0);
        result = 31 * result + (this.parityStatusModificationTime != null ? this.parityStatusModificationTime.hashCode() : 0);
        result = 31 * result + (this.parityFileName != null ? this.parityFileName.hashCode() : 0);
        result = 31 * result + (this.lostBlocks != null ? this.lostBlocks.hashCode() : 0);
        result = 31 * result + (this.lostParityBlocks != null ? this.lostParityBlocks.hashCode() : 0);
        result = 31 * result + (this.revoked != null ? this.revoked.hashCode() : 0);
        return result;
    }

    public static enum Finder implements FinderType<EncodingStatus>
    {
        ByInodeId,
        ByInodeIds,
        ByParityInodeId,
        ByParityInodeIds;


        @Override
        public Class getType() {
            return EncodingStatus.class;
        }

        @Override
        public FinderType.Annotation getAnnotated() {
            switch (this) {
                case ByInodeId: {
                    return FinderType.Annotation.PrimaryKey;
                }
                case ByInodeIds: {
                    return FinderType.Annotation.Batched;
                }
                case ByParityInodeId: {
                    return FinderType.Annotation.IndexScan;
                }
                case ByParityInodeIds: {
                    return FinderType.Annotation.IndexScan;
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum Counter implements CounterType<EncodingStatus>
    {
        RequestedEncodings,
        ActiveEncodings,
        ActiveRepairs,
        Encoded;


        @Override
        public Class getType() {
            return EncodingStatus.class;
        }
    }

    public static enum ParityStatus {
        HEALTHY,
        REPAIR_REQUESTED,
        REPAIR_ACTIVE,
        REPAIR_CANCELED,
        REPAIR_FAILED;

    }

    public static enum Status {
        NOT_ENCODED,
        ENCODING_REQUESTED,
        COPY_ENCODING_REQUESTED,
        ENCODING_ACTIVE,
        ENCODING_CANCELED,
        ENCODING_FAILED,
        ENCODED,
        REPAIR_REQUESTED,
        REPAIR_ACTIVE,
        REPAIR_CANCELED,
        REPAIR_FAILED,
        DELETED;

    }
}

