/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.handler;

import io.hops.exception.LockUpgradeException;
import io.hops.exception.StorageException;
import io.hops.exception.TransientStorageException;
import io.hops.log.NDCWrapper;
import io.hops.transaction.EntityManager;
import io.hops.transaction.TransactionInfo;
import io.hops.transaction.context.TransactionsStats;
import io.hops.transaction.handler.RequestHandler;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockAcquirer;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;

public abstract class TransactionalRequestHandler
extends RequestHandler {
    public TransactionalRequestHandler(RequestHandler.OperationType opType) {
        super(opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object execute(Object info) throws IOException {
        boolean committed = false;
        int tryCount = 0;
        Object txRetValue = null;
        if (tryCount <= RETRY_COUNT) {
            Object opName;
            long expWaitTime = this.exponentialBackoff();
            long txStartTime = System.currentTimeMillis();
            long oldTime = System.currentTimeMillis();
            long setupTime = -1L;
            long beginTxTime = -1L;
            long acquireLockTime = -1L;
            long inMemoryProcessingTime = -1L;
            long commitTime = -1L;
            long totalTime = -1L;
            TransactionLockAcquirer locksAcquirer = null;
            ++tryCount;
            IOException ignoredException = null;
            committed = false;
            EntityManager.preventStorageCall(false);
            try {
                this.setNDC(info);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Pretransaction phase started");
                }
                this.preTransactionSetup();
                this.removeNDC();
                this.setNDC(info);
                setupTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Pretransaction phase finished. Time " + setupTime + " ms"));
                }
                this.setRandomPartitioningKey();
                EntityManager.begin();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"TX Started");
                }
                beginTxTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                locksAcquirer = this.newLockAcquirer();
                this.acquireLock(locksAcquirer.getLocks());
                locksAcquirer.acquire();
                acquireLockTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("All Locks Acquired. Time " + acquireLockTime + " ms"));
                }
                this.removeNDC();
                this.setNDC(info);
                EntityManager.preventStorageCall(true);
                try {
                    txRetValue = this.performTask();
                }
                catch (IOException e) {
                    if (this.shouldAbort(e)) {
                        throw e;
                    }
                    ignoredException = e;
                }
                inMemoryProcessingTime = System.currentTimeMillis() - oldTime;
                oldTime = System.currentTimeMillis();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("In Memory Processing Finished. Time " + inMemoryProcessingTime + " ms"));
                }
                TransactionsStats.TransactionStat stat = TransactionsStats.getInstance().collectStats(this.opType, ignoredException);
                EntityManager.commit(locksAcquirer.getLocks());
                committed = true;
                commitTime = System.currentTimeMillis() - oldTime;
                if (stat != null) {
                    stat.setTimes(acquireLockTime, inMemoryProcessingTime, commitTime);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("TX committed. Time " + commitTime + " ms"));
                }
                totalTime = System.currentTimeMillis() - txStartTime;
                if (LOG.isDebugEnabled()) {
                    opName = !NDCWrapper.NDCEnabled() ? this.opType + " " : "";
                    LOG.debug((Object)((String)opName + "TX Finished. TX Stats: Try Count: " + tryCount + " Stepup: " + setupTime + " ms, Begin Tx:" + beginTxTime + " ms, Acquire Locks: " + acquireLockTime + "ms, In Memory Processing: " + inMemoryProcessingTime + "ms, Commit Time: " + commitTime + "ms, Total Time: " + totalTime + "ms. " + this.getINodeLockInfo(locksAcquirer.getLocks())));
                }
                if (info != null && info instanceof TransactionInfo) {
                    ((TransactionInfo)info).performPostTransactionAction();
                }
                opName = txRetValue;
                return opName;
            }
            catch (Throwable t) {
                Object object = opName = !NDCWrapper.NDCEnabled() ? this.opType + " " : "";
                if (!((String)opName).equals("GET_BLOCK_LOCATIONS") || !(t instanceof LockUpgradeException)) {
                    LOG.error((Object)((String)opName + "TX Failed. total tx time " + (System.currentTimeMillis() - txStartTime) + " msec. TotalRetryCount(" + RETRY_COUNT + ") RemainingRetries(" + (RETRY_COUNT - tryCount) + ") TX Stats: Setup: " + setupTime + "ms Acquire Locks: " + acquireLockTime + "ms, In Memory Processing: " + inMemoryProcessingTime + "ms, Commit Time: " + commitTime + "ms, Total Time: " + totalTime + "ms. "), t);
                }
                if (!(t instanceof TransientStorageException) || tryCount > RETRY_COUNT) {
                    throw t;
                }
            }
            finally {
                this.removeNDC();
                if (!committed && locksAcquirer != null) {
                    try {
                        LOG.error((Object)"Rollback the TX");
                        EntityManager.rollback(locksAcquirer.getLocks());
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Could not rollback transaction", (Throwable)e);
                    }
                }
                EntityManager.removeContext();
                if (ignoredException != null) {
                    throw ignoredException;
                }
            }
        }
        throw new RuntimeException("TransactionalRequestHandler did not execute");
    }

    private String getINodeLockInfo(TransactionLocks locks) {
        String inodeLockMsg = "";
        try {
            Lock ilock;
            if (locks != null && (ilock = locks.getLock(Lock.Type.INode)) != null) {
                inodeLockMsg = ilock.toString();
            }
        }
        catch (TransactionLocks.LockNotAddedException lockNotAddedException) {
            // empty catch block
        }
        return inodeLockMsg;
    }

    protected abstract void preTransactionSetup() throws IOException;

    public abstract void acquireLock(TransactionLocks var1) throws IOException;

    protected abstract TransactionLockAcquirer newLockAcquirer();

    @Override
    public TransactionalRequestHandler setParams(Object ... params) {
        this.params = params;
        return this;
    }

    private void setNDC(Object info) {
        if (info != null && info instanceof TransactionInfo) {
            NDCWrapper.push(((TransactionInfo)info).getContextName(this.opType));
        } else {
            NDCWrapper.push(this.opType.toString());
        }
    }

    private void removeNDC() {
        NDCWrapper.clear();
        NDCWrapper.remove();
    }

    private void setRandomPartitioningKey() throws StorageException, StorageException {
    }

    protected abstract boolean shouldAbort(Exception var1);
}

