/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageCallPreventedException;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.CounterType;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.context.EntityContextStat;
import io.hops.transaction.context.TransactionContext;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.lock.TransactionLocks;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EntityContext<T> {
    protected static String NOT_SUPPORTED_YET = "Not supported yet.";
    protected static String UNSUPPORTED_FINDER = "Unsupported finder.";
    protected static String UNSUPPORTED_COUNTER = "Unsupported counter.";
    private static final Log LOG = LogFactory.getLog(TransactionContext.class);
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    protected boolean storageCallPrevented = false;
    public static ThreadLocal<LockMode> currentLockMode = new ThreadLocal();

    public abstract void add(T var1) throws TransactionContextException, StorageException;

    public abstract void clear() throws TransactionContextException;

    public abstract int count(CounterType<T> var1, Object ... var2) throws TransactionContextException, StorageException;

    public abstract T find(FinderType<T> var1, Object ... var2) throws TransactionContextException, StorageException;

    public abstract Collection<T> findList(FinderType<T> var1, Object ... var2) throws TransactionContextException, StorageException;

    public abstract void prepare(TransactionLocks var1) throws TransactionContextException, StorageException;

    public abstract void remove(T var1) throws TransactionContextException;

    public abstract void removeAll() throws TransactionContextException, StorageException;

    public abstract void update(T var1) throws TransactionContextException;

    public abstract void snapshotMaintenance(TransactionContextMaintenanceCmds var1, Object ... var2) throws TransactionContextException;

    public EntityContextStat collectSnapshotStat() throws TransactionContextException {
        throw new UnsupportedOperationException("Please Implement Me");
    }

    protected boolean isLogDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    private static void log(String opName, CacheHitState state, Object ... params) {
        LockMode curLock;
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        if (state == CacheHitState.HIT) {
            message.append(ANSI_GREEN).append(opName).append(" ").append("hit").append(ANSI_RESET);
        } else if (state == CacheHitState.LOSS) {
            curLock = currentLockMode.get();
            message.append(ANSI_RED);
            if (curLock != null) {
                message.append(curLock.name()).append(" ");
            }
            message.append(opName).append(" ").append("loss").append(ANSI_RESET);
        } else if (state == CacheHitState.LOSS_LOCK_UPGRADE) {
            curLock = currentLockMode.get();
            message.append(ANSI_BLUE);
            if (curLock != null) {
                message.append(curLock.name()).append(" ");
            }
            message.append(opName).append(" ").append("loss").append(ANSI_RESET);
        } else {
            message.append(opName).append(" ");
        }
        message.append(" ");
        if (params.length > 1) {
            for (int i = 0; i < params.length; i += 2) {
                message.append(" ").append(params[i]);
                message.append("=").append(params[i + 1]);
            }
        }
        LOG.debug((Object)message.toString());
    }

    protected void logError(String msg) {
        StringBuilder message = new StringBuilder();
        message.append(ANSI_RED);
        message.append(msg).append(" ");
        message.append(ANSI_RESET);
        LOG.fatal((Object)message.toString());
    }

    protected void log(String opName, Object ... params) {
        EntityContext.log(opName, CacheHitState.NA, params);
    }

    public static void log(FinderType finderType, CacheHitState state, Object ... params) {
        EntityContext.log(EntityContext.getOperationMessage(finderType), state, params);
    }

    private static String getOperationMessage(FinderType finder) {
        return "find-" + finder.getType().getSimpleName().toLowerCase() + "-" + finder.toString();
    }

    public void preventStorageCall(boolean val) {
        this.storageCallPrevented = val;
    }

    public static void setLockMode(LockMode lock) {
        currentLockMode.set(lock);
    }

    public static LockMode getLockMode() {
        return currentLockMode.get();
    }

    protected void aboutToAccessStorage(FinderType finderType) throws StorageCallPreventedException {
        this.aboutToAccessStorage(finderType, "");
    }

    protected void aboutToAccessStorage(FinderType finderType, Object ... params) throws StorageCallPreventedException {
        if (this.storageCallPrevented) {
            throw new StorageCallPreventedException("[" + finderType + "] Trying to access storage while it is disable in transaction, inconsistent transaction context statement. Params=" + Arrays.toString(params));
        }
    }

    protected boolean preventStorageCalls() {
        return this.storageCallPrevented;
    }

    static enum CacheHitState {
        HIT,
        LOSS,
        LOSS_LOCK_UPGRADE,
        NA;

    }

    public static enum LockMode {
        READ_LOCK,
        WRITE_LOCK,
        READ_COMMITTED;

    }
}

