/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.hdfs.entity;

public class MetadataLogEntry {
    private final int datasetId;
    private final int inodeId;
    private final int inodePartitionId;
    private final int inodeParentId;
    private final String inodeName;
    private int logicalTime;
    private final Operation operation;

    public MetadataLogEntry(int datasetId, int inodeId, int inodePartitionId, int inodeParentId, String inodeName, int logicalTime, Operation operation) {
        this.datasetId = datasetId;
        this.inodeId = inodeId;
        this.inodePartitionId = inodePartitionId;
        this.inodeParentId = inodeParentId;
        this.inodeName = inodeName;
        this.logicalTime = logicalTime;
        this.operation = operation;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public int getInodeId() {
        return this.inodeId;
    }

    public int getLogicalTime() {
        return this.logicalTime;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public short getOperationOrdinal() {
        return (short)this.operation.ordinal();
    }

    public int getInodePartitionId() {
        return this.inodePartitionId;
    }

    public int getInodeParentId() {
        return this.inodeParentId;
    }

    public String getInodeName() {
        return this.inodeName;
    }

    public String toString() {
        return "MetadataLogEntry{datasetId=" + this.datasetId + ", inodeId=" + this.inodeId + ", inodePartitionId=" + this.inodePartitionId + ", inodeParentId=" + this.inodeParentId + ", inodeName='" + this.inodeName + '\'' + ", logicalTime=" + this.logicalTime + ", operation=" + (Object)((Object)this.operation) + '}';
    }

    public static enum Operation {
        ADD,
        DELETE,
        UPDATE,
        RENAME,
        CHANGEDATASET;

    }
}

